/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.tooling.ui.handlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.ViewersMultiSandboxView;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherCollection;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;

public abstract class InitializeViewersHandler
extends AbstractHandler {
    public InitializeViewersHandler(IModelConnectorTypeEnum modelconnectortype) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            Object firstElement = ((TreeSelection)selection).getFirstElement();
            try {
                Iterator iterator;
                IFilteredMatcherCollection parent;
                Iterable filteredMatchers;
                if (firstElement instanceof IFilteredMatcherContent) {
                    IFilteredMatcherContent matcherContent = (IFilteredMatcherContent)firstElement;
                    ViatraQueryMatcher matcher = matcherContent.getMatcher();
                    EMFScope scope = (EMFScope)matcher.getEngine().getScope();
                    IFilteredMatcherCollection parent2 = matcherContent.getParent();
                    this.initializeViewersSandboxOnCollection(scope, parent2);
                } else if (firstElement instanceof IFilteredMatcherCollection && (filteredMatchers = (parent = (IFilteredMatcherCollection)firstElement).getFilteredMatchers()) != null && (iterator = filteredMatchers.iterator()) != null && iterator.hasNext()) {
                    IFilteredMatcherContent matcherContent = (IFilteredMatcherContent)iterator.next();
                    EMFScope scope = (EMFScope)matcherContent.getMatcher().getEngine().getScope();
                    this.initializeViewersSandboxOnCollection(scope, parent);
                }
            }
            catch (ViatraQueryException e) {
                throw new ExecutionException("Error initializing pattern matcher.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ExecutionException("Invalid selection", (Throwable)e);
            }
        }
        return null;
    }

    private void initializeViewersSandboxOnCollection(EMFScope scope, IFilteredMatcherCollection parent) {
        Iterable filteredMatchers = parent.getFilteredMatchers();
        HashSet specifications = new HashSet();
        ViewerDataFilter dataFilter = new ViewerDataFilter();
        for (IFilteredMatcherContent filteredMatcherContent : filteredMatchers) {
            IQuerySpecification specification = filteredMatcherContent.getMatcher().getSpecification();
            specifications.add(specification);
            IPatternMatch filter = filteredMatcherContent.getFilterMatch();
            if (!Arrays.stream(filter.toArray()).anyMatch(Objects::nonNull)) continue;
            dataFilter.addSingleFilter(specification, filter);
        }
        ViewersMultiSandboxView.ensureOpen();
        ViewersMultiSandboxView.getInstance().initializeContents(scope, specifications, dataFilter);
    }
}

