/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.equinox.SuppliedFrameworkAware;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.AgreementPage;
import org.eclipse.passage.lic.internal.jface.i18n.AgreementsDialogMessages;
import org.eclipse.swt.widgets.Shell;

final class AgreementsWizard
extends Wizard {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Collection<AgreementToAccept> agreements;

    AgreementsWizard(Collection<AgreementToAccept> agreements) {
        this.agreements = agreements;
        this.setWindowTitle(AgreementsDialogMessages.AgreementsWizard_description);
    }

    public void addPages() {
        this.agreements.stream().map(AgreementPage::new).forEach(arg_0 -> ((AgreementsWizard)this).addPage(arg_0));
    }

    public boolean performFinish() {
        boolean success;
        Optional<AgreementAcceptanceService> acceptance = this.acceptance();
        if (!acceptance.isPresent()) {
            this.reportInsufficientConfiguration();
        }
        if (!(success = this.performAcceptance(acceptance.get()))) {
            this.reportFailure();
        }
        return true;
    }

    private boolean performAcceptance(AgreementAcceptanceService acceptance) {
        boolean success = true;
        for (AgreementToAccept agreement : this.agreements) {
            try {
                acceptance.accept(() -> agreement.acceptance().content());
            }
            catch (Exception e) {
                success = false;
                e.printStackTrace();
                this.log.error((Object)e);
            }
        }
        return success;
    }

    private void reportInsufficientConfiguration() {
        MessageDialog.openError((Shell)this.getShell(), (String)AgreementsDialogMessages.AgreementsWizard_error, (String)AgreementsDialogMessages.AgreementsWizard_error_description);
    }

    private void reportFailure() {
        MessageDialog.openError((Shell)this.getShell(), (String)AgreementsDialogMessages.AgreementsWizard_failure, (String)AgreementsDialogMessages.AgreementsWizard_failure_description);
    }

    private Optional<AgreementAcceptanceService> acceptance() {
        return new SuppliedFrameworkAware().withFramework(framework -> framework.accessCycleConfiguration().acceptance());
    }
}

