/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal.query;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.papyrus.emf.facet.efacet.core.FacetUtils;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;

public final class QueryUtils {
    private QueryUtils() {
    }

    public static String getQueryDescription(Query query) {
        StringBuffer sb = new StringBuffer();
        sb.append("[Query eClass:");
        sb.append(query.eClass().getName());
        DerivedTypedElement owningDerivedTypedElement = QueryUtils.getOwningDerivedTypedElement(query);
        if (owningDerivedTypedElement != null) {
            sb.append(" defined on ");
            sb.append(owningDerivedTypedElement.getClass().getSimpleName());
            EClassifier eType = owningDerivedTypedElement.getEType();
            if (eType != null) {
                sb.append(" of type '");
                sb.append(eType.getName());
                sb.append("' named: '");
            } else {
                sb.append(" named: '");
            }
            sb.append(owningDerivedTypedElement.getName());
            sb.append("'");
        } else {
            sb.append(" with a null owning derived typed element");
        }
        sb.append("]");
        return sb.toString();
    }

    public static EClassifier getReturnType(Query query) {
        EClassifier result = null;
        DerivedTypedElement owningDTE = QueryUtils.getOwningDerivedTypedElement(query);
        if (owningDTE != null) {
            result = owningDTE.getEType();
        }
        return result;
    }

    public static EClassifier getSourceType(Query query) {
        EClass result = null;
        DerivedTypedElement owningDTE = QueryUtils.getOwningDerivedTypedElement(query);
        if (owningDTE != null) {
            EObject eContainer = QueryUtils.getOwningDerivedTypedElement(query).eContainer();
            if (eContainer instanceof Facet) {
                Facet facet = (Facet)eContainer;
                result = FacetUtils.getExtendedMetaclass(facet);
            } else if (eContainer instanceof ETypedElement) {
                ETypedElement typedElement = (ETypedElement)eContainer;
                result = typedElement.getEType();
            }
        }
        return result;
    }

    public static DerivedTypedElement getOwningDerivedTypedElement(Query query) {
        DerivedTypedElement result = null;
        EObject container = query.eContainer();
        while (container != null) {
            if (container instanceof DerivedTypedElement) {
                result = (DerivedTypedElement)container;
                break;
            }
            container = container.eContainer();
        }
        if (result == null) {
            throw new IllegalStateException("Query must always be contained by a DerivedTypedElement");
        }
        return (DerivedTypedElement)container;
    }

    public static boolean isMany(Query query) {
        boolean result = false;
        DerivedTypedElement owningDTE = QueryUtils.getOwningDerivedTypedElement(query);
        if (owningDTE != null) {
            result = owningDTE.isMany();
        }
        return result;
    }
}

