/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterComboBlock;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.TclInterpreterComboBlock;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.wizards.IBuildpathContainerPageExtension;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class TclPackagesContainerPage
extends NewElementWizardPage
implements IBuildpathContainerPage,
IBuildpathContainerPageExtension {
    private Set<String> packages = new HashSet<String>();
    private Set<String> autoPackages = new HashSet<String>();
    private IBuildpathEntry entry;
    private TreeViewer fElements;
    private IScriptProject scriptProject;

    public TclPackagesContainerPage() {
        super("Libraries");
    }

    protected AbstractInterpreterComboBlock getInterpreterBlock() {
        return new TclInterpreterComboBlock(null);
    }

    public boolean finish() {
        return true;
    }

    public IBuildpathEntry getSelection() {
        IBuildpathEntry createPackagesContainer = InterpreterContainerHelper.createPackagesContainer(this.packages, this.autoPackages, (IPath)new Path(InterpreterContainerHelper.CONTAINER_PATH).append(this.scriptProject.getElementName()));
        return createPackagesContainer;
    }

    public void setSelection(IBuildpathEntry containerEntry) {
        this.entry = containerEntry;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.fElements = new TreeViewer(composite);
        GridData data = new GridData(4, 4, true, true);
        this.fElements.getTree().setLayoutData((Object)data);
        Composite buttons = new Composite(composite, 0);
        GridData data2 = new GridData(4, 4, false, false);
        buttons.setLayoutData((Object)data2);
        GridLayout gridLayout2 = new GridLayout(1, true);
        buttons.setLayout((Layout)gridLayout2);
        Button add = new Button(buttons, 8);
        data2 = new GridData(4, -1, false, false);
        add.setLayoutData((Object)data2);
        add.setText("Add");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclPackagesContainerPage.this.addPackage();
            }
        });
        Button addall = new Button(buttons, 8);
        data2 = new GridData(4, -1, false, false);
        addall.setLayoutData((Object)data2);
        addall.setText("Add all");
        addall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclPackagesContainerPage.this.addAllPackages();
            }
        });
        Button remove = new Button(buttons, 8);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclPackagesContainerPage.this.removePackage();
            }
        });
        remove.setText("Remove");
        remove.setLayoutData((Object)data2);
        this.setControl((Control)composite);
        this.setTitle("Packages");
        this.setMessage("Package dependencies list");
        this.setDescription("Package dependencies list");
        this.fElements.setContentProvider((IContentProvider)new PackagesContentProvider());
        this.fElements.setLabelProvider((IBaseLabelProvider)new PackagesLabelProvider());
        this.fElements.setInput(this.packages);
        this.fElements.addSelectionChangedListener(event -> {
            IStructuredSelection selection = event.getStructuredSelection();
            remove.setEnabled(!selection.isEmpty());
        });
        remove.setEnabled(false);
    }

    protected void removePackage() {
        ITreeSelection sel = this.fElements.getStructuredSelection();
        boolean update = false;
        for (String pkg : sel) {
            boolean res = this.packages.remove(pkg);
            if (!res) continue;
            update = res;
        }
        if (update) {
            this.refreshView();
        }
    }

    private void refreshView() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.fElements.refresh());
    }

    protected void addPackage() {
        IInterpreterInstall install;
        block6: {
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.scriptProject);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (install != null) {
            Set packages = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install);
            final HashSet names = new HashSet();
            names.addAll(packages);
            ListDialog dialog = new ListDialog(this.fElements.getControl().getShell());
            dialog.setContentProvider(new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return names.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            dialog.setLabelProvider((ILabelProvider)new PackagesLabelProvider());
            dialog.setInput(names);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                int i = 0;
                while (i < result.length) {
                    String pkg = (String)result[i];
                    this.packages.add(pkg);
                    ++i;
                }
                this.refreshView();
            }
        } else {
            MessageBox box = new MessageBox(this.fElements.getControl().getShell(), 65570);
            box.setText("Packages");
            box.setText("Project interpreter could not be found...");
            box.open();
        }
    }

    protected void addAllPackages() {
        IInterpreterInstall install;
        block4: {
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.scriptProject);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (install != null) {
            Set packages = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install);
            this.packages.addAll(packages);
            this.refreshView();
        } else {
            MessageBox box = new MessageBox(this.fElements.getControl().getShell(), 65570);
            box.setText("Packages");
            box.setText("Project interpreter could not be found...");
            box.open();
        }
    }

    public void initialize(IScriptProject project, IBuildpathEntry[] currentEntries) {
        this.scriptProject = project;
        HashSet set = new HashSet();
        HashSet autoSet = new HashSet();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project, set, autoSet);
        this.packages.addAll(set);
        this.autoPackages.addAll(autoSet);
    }

    private class PackagesContentProvider
    implements ITreeContentProvider {
        private final Object[] NONE_OBJECT = new Object[0];

        private PackagesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Set) {
                return this.getElements(parentElement);
            }
            return this.NONE_OBJECT;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Set) {
                return TclPackagesContainerPage.this.packages.toArray();
            }
            return this.NONE_OBJECT;
        }
    }

    public class PackagesLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.package_obj.png");
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return super.getText(element);
        }
    }
}

