/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.assist;

import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.internal.corext.template.c.CContext;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Point;

public class QtProposalContext
extends CContext {
    private final String contextId;

    public QtProposalContext(ICEditorContentAssistInvocationContext context, TemplateContextType ctxType) {
        super(ctxType, context.getDocument(), QtProposalContext.getCompletionPosition(context), context.getTranslationUnit());
        this.contextId = ctxType.getId();
    }

    private static Position getCompletionPosition(ICEditorContentAssistInvocationContext context) {
        Point selection;
        String prefix;
        int adjustment = 0;
        IASTCompletionNode node = context.getCompletionNode();
        if (node != null && (prefix = node.getPrefix()) != null) {
            adjustment -= prefix.length();
        }
        int length = -adjustment;
        ITextViewer viewer = context.getViewer();
        if (viewer != null && (selection = viewer.getSelectedRange()) != null && selection.y > 0) {
            length += selection.y;
        }
        int offset = context.getInvocationOffset() + adjustment;
        return new Position(offset, length);
    }

    public boolean canEvaluate(Template template) {
        return this.contextId.equals(template.getContextTypeId());
    }

    public int getStart() {
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && this.isUnicodeIdentifierPartOrPoundSign(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException e) {
            return super.getStart();
        }
    }

    private boolean isUnicodeIdentifierPartOrPoundSign(char c) {
        return Character.isUnicodeIdentifierPart(c) || c == '#';
    }
}

