/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.SwarmInit;
import org.mandas.docker.client.messages.swarm.SwarmSpec;

final class ImmutableSwarmInit
implements SwarmInit {
    private final String listenAddr;
    private final String advertiseAddr;
    @Nullable
    private final Boolean forceNewCluster;
    @Nullable
    private final SwarmSpec swarmSpec;

    private ImmutableSwarmInit(String listenAddr, String advertiseAddr, @Nullable Boolean forceNewCluster, @Nullable SwarmSpec swarmSpec) {
        this.listenAddr = listenAddr;
        this.advertiseAddr = advertiseAddr;
        this.forceNewCluster = forceNewCluster;
        this.swarmSpec = swarmSpec;
    }

    @Override
    @JsonProperty(value="ListenAddr")
    public String listenAddr() {
        return this.listenAddr;
    }

    @Override
    @JsonProperty(value="AdvertiseAddr")
    public String advertiseAddr() {
        return this.advertiseAddr;
    }

    @Override
    @JsonProperty(value="ForceNewCluster")
    @Nullable
    public Boolean forceNewCluster() {
        return this.forceNewCluster;
    }

    @Override
    @JsonProperty(value="Spec")
    @Nullable
    public SwarmSpec swarmSpec() {
        return this.swarmSpec;
    }

    public final ImmutableSwarmInit withListenAddr(String value) {
        String newValue = Objects.requireNonNull(value, "listenAddr");
        if (this.listenAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmInit(newValue, this.advertiseAddr, this.forceNewCluster, this.swarmSpec);
    }

    public final ImmutableSwarmInit withAdvertiseAddr(String value) {
        String newValue = Objects.requireNonNull(value, "advertiseAddr");
        if (this.advertiseAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmInit(this.listenAddr, newValue, this.forceNewCluster, this.swarmSpec);
    }

    public final ImmutableSwarmInit withForceNewCluster(@Nullable Boolean value) {
        if (Objects.equals(this.forceNewCluster, value)) {
            return this;
        }
        return new ImmutableSwarmInit(this.listenAddr, this.advertiseAddr, value, this.swarmSpec);
    }

    public final ImmutableSwarmInit withSwarmSpec(@Nullable SwarmSpec value) {
        if (this.swarmSpec == value) {
            return this;
        }
        return new ImmutableSwarmInit(this.listenAddr, this.advertiseAddr, this.forceNewCluster, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSwarmInit && this.equalTo((ImmutableSwarmInit)another);
    }

    private boolean equalTo(ImmutableSwarmInit another) {
        return this.listenAddr.equals(another.listenAddr) && this.advertiseAddr.equals(another.advertiseAddr) && Objects.equals(this.forceNewCluster, another.forceNewCluster) && Objects.equals(this.swarmSpec, another.swarmSpec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.listenAddr.hashCode();
        h += (h << 5) + this.advertiseAddr.hashCode();
        h += (h << 5) + Objects.hashCode(this.forceNewCluster);
        h += (h << 5) + Objects.hashCode(this.swarmSpec);
        return h;
    }

    public String toString() {
        return "SwarmInit{listenAddr=" + this.listenAddr + ", advertiseAddr=" + this.advertiseAddr + ", forceNewCluster=" + this.forceNewCluster + ", swarmSpec=" + this.swarmSpec + "}";
    }

    public static ImmutableSwarmInit copyOf(SwarmInit instance) {
        if (instance instanceof ImmutableSwarmInit) {
            return (ImmutableSwarmInit)instance;
        }
        return ImmutableSwarmInit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements SwarmInit.Builder {
        private static final long INIT_BIT_LISTEN_ADDR = 1L;
        private static final long INIT_BIT_ADVERTISE_ADDR = 2L;
        private long initBits = 3L;
        private String listenAddr;
        private String advertiseAddr;
        private Boolean forceNewCluster;
        private SwarmSpec swarmSpec;

        private Builder() {
        }

        public final Builder from(SwarmInit instance) {
            SwarmSpec swarmSpecValue;
            Objects.requireNonNull(instance, "instance");
            this.listenAddr(instance.listenAddr());
            this.advertiseAddr(instance.advertiseAddr());
            Boolean forceNewClusterValue = instance.forceNewCluster();
            if (forceNewClusterValue != null) {
                this.forceNewCluster(forceNewClusterValue);
            }
            if ((swarmSpecValue = instance.swarmSpec()) != null) {
                this.swarmSpec(swarmSpecValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="ListenAddr")
        public final Builder listenAddr(String listenAddr) {
            this.listenAddr = Objects.requireNonNull(listenAddr, "listenAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="AdvertiseAddr")
        public final Builder advertiseAddr(String advertiseAddr) {
            this.advertiseAddr = Objects.requireNonNull(advertiseAddr, "advertiseAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="ForceNewCluster")
        public final Builder forceNewCluster(@Nullable Boolean forceNewCluster) {
            this.forceNewCluster = forceNewCluster;
            return this;
        }

        @Override
        @JsonProperty(value="Spec")
        public final Builder swarmSpec(@Nullable SwarmSpec swarmSpec) {
            this.swarmSpec = swarmSpec;
            return this;
        }

        @Override
        public ImmutableSwarmInit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSwarmInit(this.listenAddr, this.advertiseAddr, this.forceNewCluster, this.swarmSpec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("listenAddr");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("advertiseAddr");
            }
            return "Cannot build SwarmInit, some of required attributes are not set " + attributes;
        }
    }
}

