/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ResourceRequirements;
import org.mandas.docker.client.messages.swarm.Resources;

final class ImmutableResourceRequirements
implements ResourceRequirements {
    @Nullable
    private final Resources limits;
    @Nullable
    private final Resources reservations;

    private ImmutableResourceRequirements(@Nullable Resources limits, @Nullable Resources reservations) {
        this.limits = limits;
        this.reservations = reservations;
    }

    @Override
    @JsonProperty(value="Limits")
    @Nullable
    public Resources limits() {
        return this.limits;
    }

    @Override
    @JsonProperty(value="Reservations")
    @Nullable
    public Resources reservations() {
        return this.reservations;
    }

    public final ImmutableResourceRequirements withLimits(@Nullable Resources value) {
        if (this.limits == value) {
            return this;
        }
        return new ImmutableResourceRequirements(value, this.reservations);
    }

    public final ImmutableResourceRequirements withReservations(@Nullable Resources value) {
        if (this.reservations == value) {
            return this;
        }
        return new ImmutableResourceRequirements(this.limits, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResourceRequirements && this.equalTo((ImmutableResourceRequirements)another);
    }

    private boolean equalTo(ImmutableResourceRequirements another) {
        return Objects.equals(this.limits, another.limits) && Objects.equals(this.reservations, another.reservations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.limits);
        h += (h << 5) + Objects.hashCode(this.reservations);
        return h;
    }

    public String toString() {
        return "ResourceRequirements{limits=" + this.limits + ", reservations=" + this.reservations + "}";
    }

    public static ImmutableResourceRequirements copyOf(ResourceRequirements instance) {
        if (instance instanceof ImmutableResourceRequirements) {
            return (ImmutableResourceRequirements)instance;
        }
        return ImmutableResourceRequirements.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ResourceRequirements.Builder {
        private Resources limits;
        private Resources reservations;

        private Builder() {
        }

        public final Builder from(ResourceRequirements instance) {
            Resources reservationsValue;
            Objects.requireNonNull(instance, "instance");
            Resources limitsValue = instance.limits();
            if (limitsValue != null) {
                this.limits(limitsValue);
            }
            if ((reservationsValue = instance.reservations()) != null) {
                this.reservations(reservationsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Limits")
        public final Builder limits(@Nullable Resources limits) {
            this.limits = limits;
            return this;
        }

        @Override
        @JsonProperty(value="Reservations")
        public final Builder reservations(@Nullable Resources reservations) {
            this.reservations = reservations;
            return this;
        }

        @Override
        public ImmutableResourceRequirements build() {
            return new ImmutableResourceRequirements(this.limits, this.reservations);
        }
    }
}

