/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.structure.property.IPropertiesToolBarContributor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;

public final class XmlPropertiesToolBarContributor
implements IPropertiesToolBarContributor {
    public static final IPropertiesToolBarContributor INSTANCE = new XmlPropertiesToolBarContributor();

    private XmlPropertiesToolBarContributor() {
    }

    public void contributeToolBar(IToolBarManager manager, List<ObjectInfo> objects) throws Exception {
        this.addGotoDefinitionAction(manager, objects);
    }

    private void addGotoDefinitionAction(IToolBarManager manager, List<ObjectInfo> objects) {
        if (objects.size() == 1 && objects.get(0) instanceof XmlObjectInfo) {
            final XmlObjectInfo javaInfo = (XmlObjectInfo)objects.get(0);
            Action gotoDefinitionAction = new Action(){

                public void run() {
                    int position = javaInfo.getElement().getOffset();
                    IDesignPageSite site = IDesignPageSite.Helper.getSite((ObjectInfo)javaInfo);
                    site.openSourcePosition(position);
                }
            };
            gotoDefinitionAction.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"structure/goto_definition.gif"));
            gotoDefinitionAction.setToolTipText(Messages.ComponentsPropertiesPage_goDefinition);
            manager.appendToGroup("org.eclipse.wb.component-properties.group.edit", (IAction)gotoDefinitionAction);
        }
    }
}

