/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.metamodel.description.validation.operations;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.validation.RuleAudit;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;

public final class ValidationRuleOperations {
    private ValidationRuleOperations() {
    }

    public static boolean checkRule(ValidationRule rule, EObject eObj) {
        boolean valid = true;
        if (rule instanceof SemanticValidationRule || rule instanceof ViewValidationRule) {
            IInterpreter acceleoInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(eObj);
            Iterator iterAudits = rule.getAudits().iterator();
            while (iterAudits.hasNext() && valid) {
                RuleAudit ruleAudit = (RuleAudit)iterAudits.next();
                String expression = ruleAudit.getAuditExpression();
                try {
                    valid = valid && acceleoInterpreter.evaluateBoolean(eObj, expression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)ruleAudit, (EStructuralFeature)ValidationPackage.eINSTANCE.getRuleAudit_AuditExpression(), e);
                }
            }
        }
        return valid;
    }

    public static String getMessage(ValidationRule rule, EObject eObj) {
        IInterpreter acceleoInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(eObj);
        String message = rule.getMessage();
        if (rule instanceof SemanticValidationRule || rule instanceof ViewValidationRule) {
            try {
                message = acceleoInterpreter.evaluateString(eObj, message);
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().error(Messages.ValidationRuleSpecOperations_evaluationErrorMsg, e);
            }
        }
        return message;
    }
}

