/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class ControlsRelationshipHandler {
    Map<Button, Control[]> controlsRelationship;
    ControlRelationshipListener controlHandler;
    boolean enableWhenMasterEnabled;

    public ControlsRelationshipHandler(Map<Button, Control[]> controlsRelationship, boolean enableWhenMasterEnabled) {
        this.controlsRelationship = controlsRelationship;
        this.controlHandler = new ControlRelationshipListener();
        this.enableWhenMasterEnabled = enableWhenMasterEnabled;
    }

    public ControlsRelationshipHandler() {
        this(new HashMap<Button, Control[]>(), true);
    }

    public ControlsRelationshipHandler(Button master, Control[] slaves, boolean enableWhenTrue) {
        this(new HashMap<Button, Control[]>(), enableWhenTrue);
        this.addControlRelationship(master, slaves);
    }

    public ControlsRelationshipHandler(Button master, Control slave, boolean enableWhenTrue) {
        this(new HashMap<Button, Control[]>(), enableWhenTrue);
        this.addControlRelationship(master, slave);
    }

    public void addControlRelationship(Button master, Control[] slaves) {
        this.controlsRelationship.put(master, slaves);
        master.addSelectionListener((SelectionListener)this.controlHandler);
    }

    public void addControlRelationship(Button master, Control slave) {
        this.controlsRelationship.put(master, new Control[]{slave});
        master.addSelectionListener((SelectionListener)this.controlHandler);
    }

    public void deleteControlRelationship(Button master) {
        this.controlsRelationship.remove(master);
        master.removeSelectionListener((SelectionListener)this.controlHandler);
    }

    public void manageDependentControls(Button btn) {
        for (Button master : this.controlsRelationship.keySet()) {
            Control[] controlList;
            Control[] obj = this.controlsRelationship.get(master);
            if (obj == null) continue;
            Control[] controlArray = controlList = obj;
            int n = controlList.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                if (btn == master && btn.getSelection()) {
                    element.setEnabled(this.enableWhenMasterEnabled);
                } else {
                    element.setEnabled(!this.enableWhenMasterEnabled);
                }
                ++n2;
            }
        }
    }

    class ControlRelationshipListener
    extends SelectionAdapter {
        ControlRelationshipListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            ControlsRelationshipHandler.this.manageDependentControls((Button)arg0.widget);
        }
    }
}

