/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.context.ui;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class WikiTextContextStructureBridge
extends AbstractContextStructureBridge {
    private static final char HANDLE_FILE_SEPARATOR = ';';
    public static final String CONTENT_TYPE = "org.eclipse.mylyn.wikitext";

    public boolean acceptsObject(Object object) {
        if (object instanceof OutlineItem) {
            return true;
        }
        if (object instanceof IFile) {
            String languageName;
            IFile file = (IFile)object;
            try {
                IContentType contentType;
                IContentDescription description = file.getContentDescription();
                if (description != null && (contentType = description.getContentType()) != null && this.isWikiText(contentType)) {
                    return true;
                }
            }
            catch (CoreException description) {
                // empty catch block
            }
            return (languageName = WikiText.getMarkupLanguageNameForFilename((String)file.getName())) != null;
        }
        return false;
    }

    private boolean isWikiText(IContentType contentType) {
        if (CONTENT_TYPE.equals(contentType.getId())) {
            return true;
        }
        IContentType baseType = contentType.getBaseType();
        if (baseType != null) {
            return this.isWikiText(baseType);
        }
        return false;
    }

    public boolean canBeLandmark(String handle) {
        return handle != null;
    }

    public boolean canFilter(Object element) {
        return true;
    }

    public List<String> getChildHandles(String handle) {
        OutlineItem item;
        Object object = this.getObjectForHandle(handle);
        if (object instanceof OutlineItem && !(item = (OutlineItem)object).getChildren().isEmpty()) {
            ArrayList<String> handles = new ArrayList<String>(item.getChildren().size());
            for (OutlineItem child : item.getChildren()) {
                handles.add(this.getHandleIdentifier(child));
            }
            return handles;
        }
        return Collections.emptyList();
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String elementHandle) {
        if (elementHandle.indexOf(59) == -1) {
            return this.parentContentType;
        }
        return CONTENT_TYPE;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        OutlineItem item;
        OutlineItem outline;
        IFile file;
        IResource resource = null;
        try {
            if (object instanceof IResource) {
                resource = (IResource)object;
            } else if (object instanceof IMarker) {
                resource = ((IMarker)object).getResource();
            } else {
                try {
                    IMarker marker = (IMarker)object.getClass().getMethod("getMarker", new Class[0]).invoke(object, new Object[0]);
                    resource = marker.getResource();
                }
                catch (Exception marker) {}
            }
        }
        catch (Exception e) {
            return null;
        }
        if (resource instanceof IFile && this.acceptsObject(file = (IFile)resource) && (outline = this.getOutline(file)) != null && (item = outline.findNearestMatchingOffset(offset)) != null) {
            return this.getHandleIdentifier(item);
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)object;
            if (item.getParent() == null) {
                return this.getFile(item).getName();
            }
            return item.getLabel();
        }
        return "";
    }

    public Object getObjectForHandle(String handle) {
        IFile file;
        if (handle == null) {
            return null;
        }
        int idxOfSeparator = handle.indexOf(59);
        String filename = handle;
        if (idxOfSeparator != -1) {
            filename = handle.substring(0, idxOfSeparator);
        }
        try {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename));
        }
        catch (Exception e) {
            return null;
        }
        if (file != null) {
            if (idxOfSeparator != -1) {
                String headingId = handle.substring(idxOfSeparator + 1);
                OutlineItem outline = this.getOutline(file);
                if (outline != null) {
                    OutlineItem item = outline.findItemById(headingId);
                    return item;
                }
            } else {
                return file;
            }
        }
        return null;
    }

    public String getParentHandle(String handle) {
        Object object = this.getObjectForHandle(handle);
        if (object instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)object;
            if (item.getParent() != null) {
                return this.getHandleIdentifier(item.getParent());
            }
            return this.getHandleIdentifier(this.getFile(item));
        }
        if (object instanceof IFile) {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            return parentBridge.getParentHandle(handle);
        }
        return null;
    }

    public boolean isDocument(String handle) {
        Object object = this.getObjectForHandle(handle);
        if (object instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)object;
            return item.getParent() == null;
        }
        return false;
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)object;
            return String.valueOf(item.getResourcePath()) + ';' + item.getId();
        }
        if (object instanceof IFile && this.acceptsObject(object)) {
            return ((IFile)object).getFullPath().toString();
        }
        return null;
    }

    private IPath getFullPath(OutlineItem item) {
        String resourcePath = item.getResourcePath();
        return resourcePath == null ? null : new Path(resourcePath);
    }

    private OutlineItem getOutline(IFile file) {
        OutlineItem outline;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null && (outline = (OutlineItem)editorPart.getAdapter(OutlineItem.class)) != null) {
            return outline;
        }
        MarkupLanguage markupLanguage = WikiText.getMarkupLanguageForFilename((String)file.getName());
        if (markupLanguage != null) {
            OutlineParser parser = new OutlineParser(markupLanguage);
            try {
                String contents = this.getContents(file);
                OutlineItem outline2 = parser.parse(contents);
                outline2.setResourcePath(file.getFullPath().toString());
                return outline2;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private String getContents(IFile file) throws Exception {
        int i;
        String charset = file.getCharset();
        StringWriter writer = new StringWriter();
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(file.getContents()), charset);
        while ((i = ((Reader)reader).read()) != -1) {
            writer.write(i);
        }
        return writer.toString();
    }

    IFile getFile(OutlineItem item) {
        IPath fullPath = this.getFullPath(item);
        return fullPath == null ? null : ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
    }
}

