/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionCollection;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionUtils;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.Utils;

public class ConversionDictionary
implements EDataType.Internal.ConversionDelegate {
    private final DictionaryType fMyType;

    public ConversionDictionary(DictionaryType type) {
        this.fMyType = type;
    }

    public String convertToString(Object value) {
        EClassifier keyType = this.fMyType.getKeyType();
        EClassifier elementType = (EClassifier)this.fMyType.getElementType();
        if (!(value instanceof Dictionary && keyType instanceof EDataType && elementType instanceof EDataType)) {
            return "";
        }
        ConversionUtils.setupConversionDelegate(keyType);
        ConversionUtils.setupConversionDelegate(elementType);
        StringBuilder result = new StringBuilder();
        Dictionary dictionary = (Dictionary)value;
        for (Object key : dictionary.keys()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            String data = keyType.getEPackage().getEFactoryInstance().convertToString((EDataType)keyType, key);
            if (ConversionUtils.isStringType(keyType)) {
                data = ConversionDictionary.escapeDictionaryElem(data);
            }
            result.append(data);
            result.append("=");
            data = elementType.getEPackage().getEFactoryInstance().convertToString((EDataType)elementType, dictionary.get(key));
            if (ConversionUtils.isStringType(elementType)) {
                data = ConversionDictionary.escapeDictionaryElem(data);
            }
            result.append(data);
        }
        return result.insert(0, "[").append("]").toString();
    }

    public Object createFromString(String literal) {
        EClassifier keyType = this.fMyType.getKeyType();
        EClassifier elementType = (EClassifier)this.fMyType.getElementType();
        if (!(keyType instanceof EDataType)) {
            throw new IllegalArgumentException("Invalid datatype: " + keyType.getName());
        }
        if (!(elementType instanceof EDataType)) {
            throw new IllegalArgumentException("Invalid datatype: " + elementType.getName());
        }
        if ((literal = literal.trim()).length() > 0 && literal.charAt(0) == '[') {
            if (literal.charAt(literal.length() - 1) != ']') {
                throw new IllegalArgumentException("Invalid datatype: " + elementType.getName());
            }
            literal = literal.substring(1, literal.length() - 1);
        }
        ConversionUtils.setupConversionDelegate(keyType);
        ConversionUtils.setupConversionDelegate(elementType);
        Dictionary<Object, Object> result = Utils.createDictionary();
        int i = 0;
        while (i < literal.length()) {
            int endIndex = ConversionDictionary.extractDictionaryKey(literal, i);
            Object key = ConversionUtils.createFromString(keyType, ConversionCollection.unescapeString(literal.substring(i, endIndex)).trim());
            i = endIndex + 1;
            endIndex = ConversionDictionary.extractDictionaryValue(literal, i);
            Object value = ConversionUtils.createFromString(elementType, ConversionCollection.unescapeString(literal.substring(i, endIndex)).trim());
            i = endIndex;
            result.put(key, value);
            ++i;
        }
        return result;
    }

    private static String escapeDictionaryElem(String literal) {
        StringBuilder result = new StringBuilder(literal.length());
        int i = 0;
        while (i < literal.length()) {
            char ch = literal.charAt(i);
            switch (ch) {
                case ',': 
                case '=': 
                case '[': 
                case '\\': 
                case ']': {
                    result.append('\\');
                }
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    private static int extractDictionaryKey(String literal, int startIndex) {
        int level = 0;
        int i = startIndex;
        while (i < literal.length()) {
            switch (literal.charAt(i)) {
                case '\\': {
                    ++i;
                    break;
                }
                case '[': {
                    ++level;
                    break;
                }
                case ']': {
                    --level;
                    break;
                }
                case '=': {
                    if (level != 0) break;
                    return i;
                }
            }
            ++i;
        }
        throw new IllegalArgumentException("Invalid dictionary key: " + literal.substring(startIndex));
    }

    private static int extractDictionaryValue(String literal, int startIndex) {
        int level = 0;
        int i = startIndex;
        while (i < literal.length()) {
            switch (literal.charAt(i)) {
                case '\\': {
                    ++i;
                    break;
                }
                case '[': {
                    ++level;
                    break;
                }
                case ']': {
                    --level;
                    break;
                }
                case ',': {
                    if (level != 0) break;
                    return i;
                }
            }
            ++i;
        }
        return literal.length();
    }
}

