/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationBaseImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationImpl<T extends IJavaElement>
extends AnnotationBaseImpl<T>
implements IAnnotation<T> {
    private Set<IParamValuePair> paramValuePairs;

    @Override
    public String getPropertyValue(String param) {
        for (IParamValuePair pair : this.getParamValuePairs()) {
            if (!param.equals(pair.getParam())) continue;
            return pair.getValue() != null ? pair.getValue().toString() : null;
        }
        return null;
    }

    public AnnotationImpl(String annotationName, Set<IParamValuePair> paramValuePairs) {
        super(annotationName);
        this.paramValuePairs = paramValuePairs;
    }

    @Override
    public Set<IParamValuePair> getParamValuePairs() {
        return this.paramValuePairs;
    }

    public void setParamValuePairs(Set<IParamValuePair> paramValuePairs) {
        this.paramValuePairs = paramValuePairs;
    }

    @Override
    public Expression getExpression(CompilationUnit unit, AST ast) {
        NormalAnnotation annot = ast.newNormalAnnotation();
        boolean wasAdded = this.addImports(ast, unit, this.getAnnotationName());
        if (wasAdded) {
            ((SimpleName)annot.getTypeName()).setIdentifier(this.getSimpleAnnotationName());
        } else {
            Name name = ast.newName(this.getAnnotationName());
            annot.setTypeName(name);
        }
        for (IParamValuePair paramValuePair : this.paramValuePairs) {
            MemberValuePair pair = ast.newMemberValuePair();
            pair.getName().setIdentifier(paramValuePair.getParam());
            pair.setValue(((ValueImpl)paramValuePair.getValue()).getExpression(unit, ast));
            annot.values().add(pair);
        }
        return annot;
    }

    @Override
    public int hashCode() {
        if (this.paramValuePairs == null || this.paramValuePairs.size() < 1) {
            return 31 * super.hashCode();
        }
        return 31 * super.hashCode() + Arrays.hashCode(this.paramValuePairs.toArray(new IParamValuePair[this.paramValuePairs.size()]));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AnnotationImpl other = (AnnotationImpl)obj;
        return Arrays.equals(this.paramValuePairs.toArray(new IParamValuePair[this.paramValuePairs.size()]), other.paramValuePairs.toArray(new IParamValuePair[this.paramValuePairs.size()]));
    }

    @Override
    public T getAppliedElement() {
        return (T)this.javaElement;
    }
}

