/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.ibm.util.ModelVersion;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class ModelHelper {
    public static final float DB2LUW_V97 = 9.7f;
    public static final float DB2LUW_V10_1 = 10.1f;
    public static final float DB2LUW_V10_5 = 10.5f;

    public static Database getDatabase(Schema schema) {
        if (schema != null) {
            if (schema.getCatalog() != null) {
                return schema.getCatalog().getDatabase();
            }
            if (schema.getDatabase() != null) {
                return schema.getDatabase();
            }
        }
        return null;
    }

    public static List<Schema> getSchemas(Database database) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Schema> schemaList = new ArrayList<Schema>();
        schemaList.addAll((Collection<Schema>)database.getSchemas());
        for (Object o : database.getCatalogs()) {
            Catalog c = (Catalog)o;
            EList schemas = c.getSchemas();
            if (schemas.isEmpty()) continue;
            schemaList.addAll((Collection<Schema>)schemas);
        }
        return schemaList;
    }

    public static float getVersionAsFloat(String versionString) {
        float version = 8.0f;
        try {
            version = Float.parseFloat(versionString.substring(1));
        }
        catch (NumberFormatException numberFormatException) {}
        return version;
    }

    public static float getZseriesVersionAsFloat(String versionString) {
        float version = 8.0f;
        try {
            version = versionString.length() >= 3 ? Float.parseFloat(versionString.substring(1, 3).trim()) : Float.parseFloat(versionString.substring(1, 2).trim());
        }
        catch (NumberFormatException numberFormatException) {}
        return version;
    }

    public static boolean isSupportPL_SQL(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 9.7f;
    }

    public static boolean isSupportSecure(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 10.1f;
    }

    public static boolean isSupportModule(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 9.7f;
    }

    public static boolean isSupportGlobalVariable(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 9.7f;
    }

    public static boolean isSupportArrayDataType(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        if ("DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 9.7f) {
            return true;
        }
        return "Oracle".equals(product);
    }

    public static boolean isSupportRowDataType(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 9.7f;
    }

    public static boolean isSupportRandomIndex(DatabaseDefinition dbDef) {
        String version;
        String product = dbDef.getProduct();
        if ("DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 10.5f) {
            return true;
        }
        return "DB2 UDB zSeries".equals(product) && ((version = dbDef.getVersion()).compareTo("V9 (New-Function Mode)") == 0 || ModelHelper.getZseriesVersionAsFloat(version) > 9.0f);
    }

    public static boolean isSupportColumnStore(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 10.5f;
    }

    public static boolean isSupportInlineFunction(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB zSeries".equals(product) && ModelHelper.getZseriesVersionAsFloat(dbDef.getVersion()) >= 10.0f;
    }

    public static ModelVersion getModelVersion(XMLResource modelResource) {
        ModelVersion version = ModelVersion.UNKNOWN;
        return version;
    }

    public static boolean isCurrentModelVersion(XMLResource resource) {
        boolean current = false;
        ModelVersion version = ModelHelper.getModelVersion(resource);
        if (ModelVersion.CURRENT_VERSION.equals((Object)version)) {
            current = true;
        }
        return current;
    }

    public static boolean isSupportPartitionedIndex(DatabaseDefinition dbDef) {
        String product = dbDef.getProduct();
        return "DB2 UDB".equals(product) && ModelHelper.getVersionAsFloat(dbDef.getVersion()) >= 9.7f;
    }

    public static Column getColumn(Table table, String colname) {
        EList columns = table.getColumns();
        for (Column currentCol : columns) {
            if (!currentCol.getName().equals(colname)) continue;
            return currentCol;
        }
        return null;
    }

    public static boolean isEqual(IndexMember member1, IndexMember member2) {
        if (member1.getColumn() != null && member2.getColumn() != null) {
            Column column1 = member1.getColumn();
            IncrementType incType1 = member1.getIncrementType();
            Column column2 = member2.getColumn();
            IncrementType incType2 = member2.getIncrementType();
            if (column1 == column2 && incType1.getValue() == incType2.getValue()) {
                return true;
            }
        } else if (member1.getExpression() != null && member2.getExpression() != null) {
            String sql1 = member1.getExpression().getSql();
            IncrementType incType1 = member1.getIncrementType();
            String sql2 = member2.getExpression().getSql();
            IncrementType incType2 = member2.getIncrementType();
            if (sql1 != null && sql1.equals(sql2) && incType1.getValue() == incType2.getValue()) {
                return true;
            }
        }
        return false;
    }
}

