/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.tree;

import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.details.tree.MessageTypeTreeNode;
import org.eclipse.bpel.ui.details.tree.TreeNode;
import org.eclipse.bpel.ui.details.tree.XSDElementDeclarationTreeNode;
import org.eclipse.bpel.ui.details.tree.XSDTypeDefinitionTreeNode;

public class BPELVariableTreeNode
extends TreeNode {
    TreeNode fNode;
    boolean isPropertyTree;
    boolean displayParticles;

    public BPELVariableTreeNode(Variable variable, boolean isCondensed, boolean isPropertyTree, boolean displayParticles) {
        super(variable, isCondensed);
        this.displayParticles = displayParticles;
        this.isPropertyTree = isPropertyTree;
        if (isCondensed) {
            if (variable.getMessageType() != null) {
                this.fNode = new MessageTypeTreeNode(variable.getMessageType(), isCondensed, isPropertyTree);
            } else if (variable.getType() != null) {
                this.fNode = new XSDTypeDefinitionTreeNode(variable.getType(), isCondensed);
            } else if (variable.getXSDElement() != null) {
                this.fNode = new XSDElementDeclarationTreeNode(variable.getXSDElement(), isCondensed);
            }
        }
    }

    @Override
    public String getLabelSuffix() {
        if (this.isCondensed && this.fNode != null) {
            return this.fNode.getLabel();
        }
        return null;
    }

    @Override
    public Object[] getChildren() {
        if (this.isCondensed) {
            return this.fNode != null ? this.fNode.getChildren() : EMPTY_ARRAY;
        }
        Variable variable = (Variable)this.modelObject;
        if (variable.getMessageType() != null) {
            return new Object[]{new MessageTypeTreeNode(variable.getMessageType(), this.isCondensed, this.isPropertyTree, this.displayParticles)};
        }
        if (variable.getType() != null) {
            return new Object[]{new XSDTypeDefinitionTreeNode(variable.getType(), this.isCondensed)};
        }
        if (variable.getXSDElement() != null) {
            return new Object[]{new XSDElementDeclarationTreeNode(variable.getXSDElement(), this.isCondensed)};
        }
        return EMPTY_ARRAY;
    }

    @Override
    public boolean hasChildren() {
        if (this.isCondensed) {
            return this.fNode != null ? this.fNode.hasChildren() : false;
        }
        Variable variable = (Variable)this.modelObject;
        return variable.getMessageType() != null || variable.getType() != null || variable.getXSDElement() != null;
    }
}

