/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor.font;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.xwt.model.property.editor.font.AbstractFontPage;
import org.eclipse.wb.internal.xwt.model.property.editor.font.FontDialog;
import org.eclipse.wb.internal.xwt.model.property.editor.font.FontInfo;
import org.eclipse.wb.internal.xwt.model.property.editor.font.FontSupport;

public final class ConstructionFontPage
extends AbstractFontPage {
    private static final String[] m_styleTitles = new String[]{"NORMAL", "BOLD", "ITALIC", "BOLD | ITALIC"};
    private static final int[] m_styleValues;
    private final String[] m_families;
    private final Text m_familyText;
    private final List m_familyList;
    private final Text m_styleText;
    private final List m_styleList;
    private final Text m_sizeText;
    private final List m_sizeList;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        m_styleValues = nArray;
    }

    public ConstructionFontPage(Composite parent, int style, FontDialog fontDialog) {
        super(parent, style, fontDialog);
        GridLayoutFactory.create((Composite)this).columns(3);
        new Label((Composite)this, 0).setText("Family:");
        new Label((Composite)this, 0).setText("Style:");
        new Label((Composite)this, 0).setText("Size:");
        this.m_familyText = new Text((Composite)this, 2056);
        GridDataFactory.create((Control)this.m_familyText).fill();
        this.m_styleText = new Text((Composite)this, 2056);
        GridDataFactory.create((Control)this.m_styleText).fill();
        this.m_sizeText = new Text((Composite)this, 2056);
        GridDataFactory.create((Control)this.m_sizeText).fill();
        this.m_familyList = new List((Composite)this, 2560);
        GridDataFactory.create((Control)this.m_familyList).hintVC(12).grab().fill();
        this.m_families = (String[])ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<String[]>(){

            public String[] runObject() throws Exception {
                return FontSupport.getFontFamilies();
            }
        }, (Object)ArrayUtils.EMPTY_STRING_ARRAY);
        this.m_familyList.setItems(this.m_families);
        this.m_familyList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = ConstructionFontPage.this.m_familyList.getSelectionIndex();
                String family = ConstructionFontPage.this.m_families[index];
                ConstructionFontPage.this.m_familyText.setText(family);
                ConstructionFontPage.this.updateFont();
            }
        });
        this.m_styleList = new List((Composite)this, 2048);
        GridDataFactory.create((Control)this.m_styleList).hintHC(20).fill();
        int i = 0;
        while (i < m_styleTitles.length) {
            String styleTitle = m_styleTitles[i];
            this.m_styleList.add(styleTitle);
            ++i;
        }
        this.m_styleList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = ConstructionFontPage.this.m_styleList.getSelectionIndex();
                String fontStyle = m_styleTitles[index];
                ConstructionFontPage.this.m_styleText.setText(fontStyle);
                ConstructionFontPage.this.updateFont();
            }
        });
        this.m_sizeList = new List((Composite)this, 2560);
        GridDataFactory.create((Control)this.m_sizeList).hintC(10, 12).fill();
        i = 5;
        while (i < 100) {
            this.m_sizeList.add(Integer.toString(i));
            ++i;
        }
        this.m_sizeList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String size = ConstructionFontPage.this.m_sizeList.getSelection()[0];
                ConstructionFontPage.this.m_sizeText.setText(size);
                ConstructionFontPage.this.updateFont();
            }
        });
    }

    private void updateFont() {
        String family = this.m_familyText.getText();
        int style = m_styleValues[0];
        int index = this.m_styleList.getSelectionIndex();
        if (index != -1) {
            style = m_styleValues[index];
        }
        int size = Integer.parseInt(this.m_sizeText.getText());
        Font font = new Font(null, family, size, style);
        this.m_fontDialog.setFontInfo(new FontInfo(font, true));
    }

    public void setFont(final FontInfo fontInfo) {
        if (fontInfo != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    Font font = fontInfo.getFont();
                    FontData fontData = font.getFontData()[0];
                    String family = fontData.getName();
                    ConstructionFontPage.this.m_familyList.setSelection(new String[]{family});
                    ConstructionFontPage.this.m_familyText.setText(family);
                    int style = fontData.getStyle();
                    int i = 0;
                    while (i < m_styleValues.length) {
                        if (style == m_styleValues[i]) {
                            ConstructionFontPage.this.m_styleList.select(i);
                            ConstructionFontPage.this.m_styleText.setText(m_styleTitles[i]);
                        }
                        ++i;
                    }
                    String text = "" + fontData.getHeight();
                    ConstructionFontPage.this.m_sizeList.setSelection(new String[]{text});
                    ConstructionFontPage.this.m_sizeText.setText(text);
                }
            });
        }
    }
}

