/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.association;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationAssociation;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerMethodBinding;

public final class InvocationSecondaryAssociation
extends InvocationAssociation {
    public InvocationSecondaryAssociation(MethodInvocation invocation) {
        super(invocation);
    }

    public boolean canDelete() {
        if (this.hasForcedDeleteTag()) {
            return true;
        }
        IMethodBinding binding = AstNodeUtils.getMethodBinding(this.m_invocation);
        DesignerMethodBinding newBinding = this.m_editor.getBindingContext().get(binding);
        List<Expression> arguments = DomGenerics.arguments(this.m_invocation);
        int i = arguments.size() - 1;
        while (i >= 0) {
            Expression argument = arguments.get(i);
            if (this.m_javaInfo.isRepresentedBy((ASTNode)argument)) {
                newBinding.removeParameterType(i);
            }
            --i;
        }
        return AstNodeUtils.getMethodBySignature(binding.getDeclaringClass(), AstNodeUtils.getMethodSignature(newBinding)) != null;
    }

    public boolean remove() throws Exception {
        if (!AstNodeUtils.isDanglingNode((ASTNode)this.m_invocation) && !this.hasForcedDeleteTag()) {
            List<Expression> arguments = DomGenerics.arguments(this.m_invocation);
            int i = arguments.size() - 1;
            while (i >= 0) {
                Expression argument = arguments.get(i);
                if (this.m_javaInfo.isRepresentedBy((ASTNode)argument)) {
                    this.m_javaInfo.getEditor().removeInvocationArgument(this.m_invocation, i);
                }
                --i;
            }
        }
        return super.remove();
    }

    private boolean hasForcedDeleteTag() {
        JavaInfo hostJavaInfo = this.m_javaInfo.getRootJava().getChildRepresentedBy((ASTNode)this.m_invocation.getExpression());
        if (hostJavaInfo != null) {
            String signature = AstNodeUtils.getMethodSignature(this.m_invocation);
            MethodDescription methodDescription = hostJavaInfo.getDescription().getMethod(signature);
            return methodDescription.hasTrueTag("secondaryAssociation.alwaysDelete");
        }
        return false;
    }
}

