/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.collection;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.entities.AbstractJsonObject;

public class Dependencies
extends AbstractJsonObject<VersionedPackage>
implements Iterable<VersionedPackage> {
    @Override
    protected void doParse(Object obj) {
        this.clear();
        if (obj instanceof LinkedHashMap) {
            for (Map.Entry entry : ((LinkedHashMap)obj).entrySet()) {
                VersionedPackage dep = new VersionedPackage();
                dep.setName((String)entry.getKey());
                dep.setVersion((String)entry.getValue());
                this.add(dep);
            }
        }
    }

    @Override
    protected Object buildJson() {
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        for (VersionedPackage dep : this) {
            out.put(dep.getName(), dep.getVersion());
        }
        return out;
    }

    public void add(VersionedPackage dependency) {
        if (!this.has(dependency)) {
            this.set(dependency.getName(), dependency);
        }
    }

    public void addAll(Dependencies dependencies) {
        for (VersionedPackage pkg : dependencies) {
            this.add(pkg);
        }
    }

    public boolean has(VersionedPackage dependency) {
        return super.has(dependency.getName());
    }

    public void remove(VersionedPackage dependency) {
        super.remove(dependency.getName());
    }

    public VersionedPackage[] toArray() {
        return this.properties.values().toArray(new VersionedPackage[0]);
    }

    @Override
    public Iterator<VersionedPackage> iterator() {
        return this.properties.values().iterator();
    }
}

