/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.JsArray;
import org.eclipse.wst.jsdt.chromium.JsDeclarativeVariable;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsObjectProperty;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBrowserImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipExpressionBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.LocationValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.PropertyDescriptorValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.RemoteObjectValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.runtime.CallArgumentParam;
import org.eclipse.wst.jsdt.chromium.util.AsyncFutureRef;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.util.JavaScriptExpressionBuilder;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

class WipValueBuilder {
    private static final Logger LOGGER = Logger.getLogger(WipValueBuilder.class.getName());
    private final WipValueLoader valueLoader;
    private static final Map<RemoteObjectValue.Type, ValueType> PROTOCOL_TYPE_TO_VALUE_TYPE = new HashMap<RemoteObjectValue.Type, ValueType>();
    private static final ValueType DEFAULT_VALUE_TYPE;

    static {
        PROTOCOL_TYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Type.STRING, new PrimitiveTypeWithValue(JsValue.Type.TYPE_STRING));
        PROTOCOL_TYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Type.BOOLEAN, new PrimitiveTypeWithValue(JsValue.Type.TYPE_BOOLEAN));
        PROTOCOL_TYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Type.NUMBER, new PrimitiveTypeWithDescription(JsValue.Type.TYPE_NUMBER));
        PROTOCOL_TYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Type.UNDEFINED, new SingletonPrimitiveType(JsValue.Type.TYPE_UNDEFINED, "undefined"));
        PROTOCOL_TYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Type.OBJECT, new ObjectType());
        PROTOCOL_TYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Type.FUNCTION, new FunctionType());
        assert (PROTOCOL_TYPE_TO_VALUE_TYPE.size() == RemoteObjectValue.Type.values().length);
        DEFAULT_VALUE_TYPE = new ObjectSubtype(JsValue.Type.TYPE_OBJECT);
    }

    WipValueBuilder(WipValueLoader valueLoader) {
        this.valueLoader = valueLoader;
    }

    public JsObjectProperty createObjectProperty(final PropertyDescriptorValue propertyDescriptor, final String hostObjectRefId, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
        final WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder = nameBuilder.getQualifiedNameBuilder();
        JsValue jsValue = this.wrap(propertyDescriptor.value(), qualifiedNameBuilder);
        final JsValue getter = this.wrapPropertyDescriptorFunction(propertyDescriptor.get(), qualifiedNameBuilder, "getter");
        final JsValue setter = this.wrapPropertyDescriptorFunction(propertyDescriptor.set(), qualifiedNameBuilder, "setter");
        return new ObjectPropertyBase(jsValue, nameBuilder){
            private static final String GETTER_VAR_NAME = "gttr";
            private static final String OBJECT_VAR_NAME = "obj";
            private static final String EVALUATE_EXPRESSION = "gttr.call(obj)";

            public JsDeclarativeVariable asDeclarativeVariable() {
                return null;
            }

            public boolean isWritable() {
                return propertyDescriptor.writable() == Boolean.TRUE;
            }

            public JsValue getGetter() {
                return getter;
            }

            public JsValue getSetter() {
                return setter;
            }

            public boolean isConfigurable() {
                return propertyDescriptor.configurable() == Boolean.TRUE;
            }

            public boolean isEnumerable() {
                return propertyDescriptor.enumerable() == Boolean.TRUE;
            }

            public JsFunction getGetterAsFunction() {
                JsObject getterObject = getter.asObject();
                if (getterObject == null) {
                    return null;
                }
                return getterObject.asFunction();
            }

            public RelayOk evaluateGet(JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) {
                WipContextBuilder.GlobalEvaluateContext evaluateContext = new WipContextBuilder.GlobalEvaluateContext(WipValueBuilder.this.valueLoader);
                JsFunction getterFunction = this.getGetterAsFunction();
                if (getterFunction == null) {
                    throw new RuntimeException("Getter is not a function");
                }
                HashMap<String, SerializableValue> context = new HashMap<String, SerializableValue>(2);
                context.put(GETTER_VAR_NAME, (SerializableValue)getterFunction);
                context.put(OBJECT_VAR_NAME, SerializableValue.Util.wrapRefId(hostObjectRefId));
                final WipExpressionBuilder.QualifiedNameBuilder pseudoPropertyNameBuilder = WipValueBuilder.createPseudoPropertyNameBuilder(qualifiedNameBuilder, "value");
                WipExpressionBuilder.ValueNameBuilder valueNameBuilder = new WipExpressionBuilder.ValueNameBuilder(){

                    @Override
                    public String getShortName() {
                        return "value";
                    }

                    @Override
                    public WipExpressionBuilder.QualifiedNameBuilder getQualifiedNameBuilder() {
                        return pseudoPropertyNameBuilder;
                    }
                };
                return evaluateContext.evaluateAsyncImpl(EVALUATE_EXPRESSION, valueNameBuilder, context, WipValueBuilder.this.valueLoader, callback, syncCallback);
            }
        };
    }

    private static WipExpressionBuilder.QualifiedNameBuilder createPseudoPropertyNameBuilder(final WipExpressionBuilder.QualifiedNameBuilder propertyValueNameBuilder, final String symbolicName) {
        return new WipExpressionBuilder.QualifiedNameBuilder(){

            @Override
            public boolean needsParentheses() {
                return false;
            }

            @Override
            public void append(StringBuilder output) {
                propertyValueNameBuilder.append(output);
                output.append("::[[").append(symbolicName).append("]]");
            }
        };
    }

    private JsValue wrapPropertyDescriptorFunction(RemoteObjectValue value, WipExpressionBuilder.QualifiedNameBuilder propertyValueNameBuilder, String symbolicName) {
        if (value == null) {
            return null;
        }
        WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder = WipValueBuilder.createPseudoPropertyNameBuilder(propertyValueNameBuilder, symbolicName);
        return this.wrap(value, qualifiedNameBuilder);
    }

    public JsVariable createVariable(RemoteObjectValue valueData, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
        WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder = nameBuilder == null ? null : nameBuilder.getQualifiedNameBuilder();
        JsValue jsValue = this.wrap(valueData, qualifiedNameBuilder);
        return WipValueBuilder.createVariable(jsValue, nameBuilder);
    }

    public JsDeclarativeVariable createDeclarativeVariable(RemoteObjectValue valueData, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
        WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder = nameBuilder == null ? null : nameBuilder.getQualifiedNameBuilder();
        JsValue jsValue = this.wrap(valueData, qualifiedNameBuilder);
        return new DeclarativeVariable(jsValue, nameBuilder);
    }

    public JsValue wrap(RemoteObjectValue valueData, WipExpressionBuilder.QualifiedNameBuilder nameBuilder) {
        if (valueData == null) {
            return null;
        }
        return WipValueBuilder.getValueType(valueData).build(valueData, this.valueLoader, nameBuilder);
    }

    public static JsVariable createVariable(JsValue jsValue, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
        return new VariableImpl(jsValue, nameBuilder);
    }

    private static ValueType getValueType(RemoteObjectValue valueData) {
        RemoteObjectValue.Type protocolType = valueData.type();
        ValueType result = (ValueType)BasicUtil.getSafe(PROTOCOL_TYPE_TO_VALUE_TYPE, (Object)((Object)protocolType));
        if (result == null) {
            LOGGER.severe("Unexpected value type: " + (Object)((Object)protocolType));
            result = DEFAULT_VALUE_TYPE;
        }
        return result;
    }

    private static class ArrayType
    extends ObjectTypeBase {
        ArrayType() {
            super(JsValue.Type.TYPE_ARRAY);
        }

        @Override
        JsValue buildNewInstance(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder nameBuilder) {
            return new Array(valueData, valueLoader, nameBuilder);
        }

        private class Array
        extends ObjectTypeBase.JsObjectBase
        implements JsArray {
            private final AtomicReference<ArrayProperties> arrayPropertiesRef;

            Array(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder nameBuilder) {
                super(valueData, valueLoader, nameBuilder);
                this.arrayPropertiesRef = new AtomicReference<Object>(null);
            }

            public JsArray asArray() {
                return this;
            }

            public JsFunction asFunction() {
                return null;
            }

            public long getLength() throws MethodIsBlockingException {
                return this.getArrayProperties().getLength();
            }

            public JsVariable get(long index) throws MethodIsBlockingException {
                return (JsVariable)BasicUtil.getSafe(this.getArrayProperties().getSparseArrayMap(), (Object)index);
            }

            public SortedMap<Long, ? extends JsVariable> toSparseArray() throws MethodIsBlockingException {
                return this.getArrayProperties().getPublicSparseArrayMap();
            }

            private ArrayProperties getArrayProperties() throws MethodIsBlockingException {
                ArrayProperties result = this.arrayPropertiesRef.get();
                if (result == null) {
                    ArrayProperties arrayProperties = this.buildArrayProperties();
                    this.arrayPropertiesRef.compareAndSet(null, arrayProperties);
                    return this.arrayPropertiesRef.get();
                }
                return result;
            }

            private ArrayProperties buildArrayProperties() throws MethodIsBlockingException {
                long l;
                WipValueLoader.ObjectProperties loadedProperties = this.getLoadedProperties();
                TreeMap<Long, JsVariable> map = new TreeMap<Long, JsVariable>();
                JsValue lengthValue = null;
                for (JsVariable jsVariable : loadedProperties.properties()) {
                    String name = jsVariable.getName();
                    Long index = JavaScriptExpressionBuilder.parsePropertyNameAsArrayIndex((String)name);
                    if (index != null) {
                        map.put(index, jsVariable);
                        continue;
                    }
                    if (!"length".equals(name)) continue;
                    lengthValue = jsVariable.getValue();
                }
                try {
                    l = Long.parseLong(lengthValue.getValueString());
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
                return new ArrayProperties(l, map);
            }
        }

        private static class ArrayProperties {
            final long length;
            final SortedMap<Long, ? extends JsVariable> sparseArrayMap;
            final SortedMap<Long, ? extends JsVariable> publicSparseArrayMap;

            ArrayProperties(long length, SortedMap<Long, ? extends JsVariable> sparseArrayMap) {
                this.length = length;
                this.sparseArrayMap = sparseArrayMap;
                this.publicSparseArrayMap = Collections.synchronizedSortedMap(Collections.unmodifiableSortedMap(sparseArrayMap));
            }

            long getLength() {
                return this.length;
            }

            SortedMap<Long, ? extends JsVariable> getSparseArrayMap() {
                return this.sparseArrayMap;
            }

            SortedMap<Long, ? extends JsVariable> getPublicSparseArrayMap() {
                return this.publicSparseArrayMap;
            }
        }
    }

    private static class DeclarativeVariable
    extends VariableImpl
    implements JsDeclarativeVariable {
        DeclarativeVariable(JsValue jsValue, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
            super(jsValue, nameBuilder);
        }

        @Override
        public JsDeclarativeVariable asDeclarativeVariable() {
            return this;
        }

        public boolean isMutable() {
            return false;
        }

        public RelayOk setValue(JsValue newValue, JsDeclarativeVariable.SetValueCallback callback, SyncCallback syncCallback) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static class FunctionType
    extends ObjectTypeBase {
        FunctionType() {
            super(JsValue.Type.TYPE_FUNCTION);
        }

        @Override
        JsValue buildNewInstance(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder nameBuilder) {
            return new FunctionValueImpl(valueData, valueLoader, nameBuilder);
        }

        private class FunctionValueImpl
        extends ObjectTypeBase.JsObjectBase
        implements JsFunction {
            private final AsyncFutureRef<WipValueLoader.Getter<LocationValue>> loadedPositionRef;

            FunctionValueImpl(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder nameBuilder) {
                super(valueData, valueLoader, nameBuilder);
                this.loadedPositionRef = new AsyncFutureRef();
            }

            public JsArray asArray() {
                return null;
            }

            public JsFunction asFunction() {
                return this;
            }

            public Script getScript() throws MethodIsBlockingException {
                LocationValue functionPosition = this.getLoadedPosition();
                WipScriptManager scriptManager = this.getRemoteValueMapping().getTabImpl().getScriptManager();
                return scriptManager.getScript(functionPosition.scriptId());
            }

            public TextStreamPosition getOpenParenPosition() throws MethodIsBlockingException {
                final LocationValue functionPosition = this.getLoadedPosition();
                return new TextStreamPosition(){

                    public int getOffset() {
                        return (Integer)WipBrowserImpl.throwUnsupported();
                    }

                    public int getLine() {
                        return (int)functionPosition.lineNumber();
                    }

                    public int getColumn() {
                        Long columnObject = functionPosition.columnNumber();
                        if (columnObject == null) {
                            return -1;
                        }
                        return columnObject.intValue();
                    }
                };
            }

            private LocationValue getLoadedPosition() throws MethodIsBlockingException {
                if (!this.loadedPositionRef.isInitialized()) {
                    this.getRemoteValueMapping().loadFunctionLocationInFuture(this.getValueData().objectId(), this.loadedPositionRef);
                }
                return (LocationValue)((WipValueLoader.Getter)this.loadedPositionRef.getSync()).get();
            }
        }
    }

    static abstract class JsValueBase
    implements JsValue,
    SerializableValue {
        JsValueBase() {
        }

        static JsValueBase cast(JsValue value) {
            if (!(value instanceof JsValueBase)) {
                throw new IllegalArgumentException("Incorrect argument type " + value.getClass());
            }
            return (JsValueBase)value;
        }
    }

    private static abstract class ObjectPropertyBase
    extends VariableBase
    implements JsObjectProperty {
        ObjectPropertyBase(JsValue jsValue, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
            super(jsValue, nameBuilder);
        }

        public JsObjectProperty asObjectProperty() {
            return this;
        }
    }

    private static class ObjectSubtype
    extends ObjectTypeBase {
        ObjectSubtype(JsValue.Type type) {
            super(type);
        }

        @Override
        JsValue buildNewInstance(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder) {
            return new ObjectTypeBase.JsObjectBase(this, valueData, valueLoader, qualifiedNameBuilder){

                public JsArray asArray() {
                    return null;
                }

                public JsFunction asFunction() {
                    return null;
                }
            };
        }
    }

    private static class ObjectType
    extends ValueType {
        private static final Map<RemoteObjectValue.Subtype, ValueType> PROTOCOL_SUBTYPE_TO_VALUE_TYPE = new HashMap<RemoteObjectValue.Subtype, ValueType>();

        static {
            ObjectSubtype objectSubtype = new ObjectSubtype(JsValue.Type.TYPE_OBJECT);
            PROTOCOL_SUBTYPE_TO_VALUE_TYPE.put(null, objectSubtype);
            PROTOCOL_SUBTYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Subtype.NULL, new SingletonPrimitiveType(JsValue.Type.TYPE_NULL, "null"));
            PROTOCOL_SUBTYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Subtype.ARRAY, new ArrayType());
            PROTOCOL_SUBTYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Subtype.REGEXP, objectSubtype);
            PROTOCOL_SUBTYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Subtype.DATE, objectSubtype);
            PROTOCOL_SUBTYPE_TO_VALUE_TYPE.put(RemoteObjectValue.Subtype.NODE, objectSubtype);
            assert (PROTOCOL_SUBTYPE_TO_VALUE_TYPE.size() == RemoteObjectValue.Subtype.values().length + 1);
        }

        private ObjectType() {
        }

        @Override
        JsValue build(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder nameBuilder) {
            ValueType secondLevelValueType = (ValueType)BasicUtil.getSafe(PROTOCOL_SUBTYPE_TO_VALUE_TYPE, (Object)((Object)valueData.subtype()));
            if (secondLevelValueType == null) {
                LOGGER.severe("Unexpected value type: " + (Object)((Object)valueData.type()) + " " + (Object)((Object)valueData.subtype()));
                secondLevelValueType = DEFAULT_VALUE_TYPE;
            }
            return secondLevelValueType.build(valueData, valueLoader, nameBuilder);
        }
    }

    private static abstract class ObjectTypeBase
    extends ValueType {
        private final JsValue.Type jsValueType;

        ObjectTypeBase(JsValue.Type jsValueType) {
            this.jsValueType = jsValueType;
        }

        @Override
        JsValue build(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder) {
            return this.buildNewInstance(valueData, valueLoader, qualifiedNameBuilder);
        }

        abstract JsValue buildNewInstance(RemoteObjectValue var1, WipValueLoader var2, WipExpressionBuilder.QualifiedNameBuilder var3);

        abstract class JsObjectBase
        extends JsValueBase
        implements JsObject {
            private final RemoteObjectValue valueData;
            private final WipValueLoader valueLoader;
            private final WipExpressionBuilder.QualifiedNameBuilder nameBuilder;
            private final AsyncFutureRef<WipValueLoader.Getter<WipValueLoader.ObjectProperties>> loadedPropertiesRef = new AsyncFutureRef();

            JsObjectBase(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder nameBuilder) {
                this.valueData = valueData;
                this.valueLoader = valueLoader;
                this.nameBuilder = nameBuilder;
            }

            public JsValue.Type getType() {
                return ObjectTypeBase.this.jsValueType;
            }

            public String getValueString() {
                return this.valueData.description();
            }

            public JsObject asObject() {
                return this;
            }

            public boolean isTruncated() {
                return false;
            }

            public String getClassName() {
                return this.valueData.className();
            }

            public RelayOk reloadHeavyValue(JsValue.ReloadBiggerCallback callback, SyncCallback syncCallback) {
                throw new UnsupportedOperationException();
            }

            public Collection<? extends JsObjectProperty> getProperties() throws MethodIsBlockingException {
                return this.getLoadedProperties().properties();
            }

            public Collection<? extends JsVariable> getInternalProperties() throws MethodIsBlockingException {
                return this.getLoadedProperties().internalProperties();
            }

            public JsVariable getProperty(String name) throws MethodIsBlockingException {
                return this.getLoadedProperties().getProperty(name);
            }

            @Override
            public String getRefId() {
                return this.valueData.objectId();
            }

            public WipValueLoader getRemoteValueMapping() {
                return this.valueLoader;
            }

            protected RemoteObjectValue getValueData() {
                return this.valueData;
            }

            @Override
            public CallArgumentParam createCallArgumentParam() {
                return new CallArgumentParam(false, null, this.valueData.objectId());
            }

            protected WipValueLoader.ObjectProperties getLoadedProperties() throws MethodIsBlockingException {
                int currentCacheState = this.getRemoteValueMapping().getCacheState();
                if (this.loadedPropertiesRef.isInitialized()) {
                    WipValueLoader.ObjectProperties result = (WipValueLoader.ObjectProperties)((WipValueLoader.Getter)this.loadedPropertiesRef.getSync()).get();
                    if (currentCacheState == result.getCacheState()) {
                        return result;
                    }
                    this.doLoadProperties(true, currentCacheState);
                } else {
                    this.doLoadProperties(false, currentCacheState);
                }
                return (WipValueLoader.ObjectProperties)((WipValueLoader.Getter)this.loadedPropertiesRef.getSync()).get();
            }

            private void doLoadProperties(boolean reload, int currentCacheState) throws MethodIsBlockingException {
                WipExpressionBuilder.ObjectPropertyNameBuilder innerNameBuilder = this.nameBuilder == null ? null : new WipExpressionBuilder.ObjectPropertyNameBuilder(this.nameBuilder);
                this.valueLoader.loadJsObjectPropertiesInFuture(this.valueData.objectId(), innerNameBuilder, reload, currentCacheState, this.loadedPropertiesRef);
            }
        }
    }

    private static abstract class PrimitiveType
    extends ValueType {
        private final JsValue.Type jsValueType;

        PrimitiveType(JsValue.Type jsValueType) {
            this.jsValueType = jsValueType;
        }

        protected abstract String getValueString(RemoteObjectValue var1);

        @Override
        JsValue build(RemoteObjectValue valueData, WipValueLoader valueLoader, WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder) {
            final Object value = valueData.value();
            final String valueString = this.getValueString(valueData);
            return new JsValueBase(){

                public JsValue.Type getType() {
                    return PrimitiveType.this.jsValueType;
                }

                public String getValueString() {
                    return valueString;
                }

                public JsObject asObject() {
                    return null;
                }

                public boolean isTruncated() {
                    return false;
                }

                @Override
                public String getRefId() {
                    return null;
                }

                public RelayOk reloadHeavyValue(JsValue.ReloadBiggerCallback callback, SyncCallback syncCallback) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public CallArgumentParam createCallArgumentParam() {
                    if (PrimitiveType.this.jsValueType == JsValue.Type.TYPE_NULL) {
                        return new CallArgumentParam(true, null, null);
                    }
                    if (PrimitiveType.this.jsValueType == JsValue.Type.TYPE_UNDEFINED) {
                        return new CallArgumentParam(false, null, null);
                    }
                    return new CallArgumentParam(true, value, null);
                }
            };
        }
    }

    private static class PrimitiveTypeWithDescription
    extends PrimitiveType {
        PrimitiveTypeWithDescription(JsValue.Type jsValueType) {
            super(jsValueType);
        }

        @Override
        protected String getValueString(RemoteObjectValue valueData) {
            return valueData.description();
        }
    }

    private static class PrimitiveTypeWithValue
    extends PrimitiveType {
        PrimitiveTypeWithValue(JsValue.Type jsValueType) {
            super(jsValueType);
        }

        @Override
        protected String getValueString(RemoteObjectValue valueData) {
            return valueData.value().toString();
        }
    }

    static interface SerializableValue {
        public CallArgumentParam createCallArgumentParam();

        public String getRefId();

        public static class Util {
            public static SerializableValue wrapRefId(final String refId) {
                return new SerializableValue(){

                    @Override
                    public CallArgumentParam createCallArgumentParam() {
                        return new CallArgumentParam(false, null, refId);
                    }

                    @Override
                    public String getRefId() {
                        return refId;
                    }
                };
            }
        }
    }

    private static class SingletonPrimitiveType
    extends PrimitiveType {
        private final String stringValue;

        SingletonPrimitiveType(JsValue.Type jsValueType, String stringValue) {
            super(jsValueType);
            this.stringValue = stringValue;
        }

        @Override
        protected String getValueString(RemoteObjectValue valueData) {
            return this.stringValue;
        }
    }

    private static abstract class ValueType {
        private ValueType() {
        }

        abstract JsValue build(RemoteObjectValue var1, WipValueLoader var2, WipExpressionBuilder.QualifiedNameBuilder var3);
    }

    private static abstract class VariableBase
    implements JsVariable {
        private final JsValue jsValue;
        private final WipExpressionBuilder.ValueNameBuilder nameBuilder;
        private volatile String qualifiedName = null;

        VariableBase(JsValue jsValue, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
            this.jsValue = jsValue;
            this.nameBuilder = nameBuilder;
        }

        public boolean isReadable() {
            return true;
        }

        public JsValue getValue() {
            return this.jsValue;
        }

        public String getName() {
            return this.nameBuilder.getShortName();
        }

        public String getFullyQualifiedName() {
            String result = this.qualifiedName;
            if (result == null) {
                WipExpressionBuilder.QualifiedNameBuilder qualifiedNameBuilder = this.nameBuilder.getQualifiedNameBuilder();
                if (qualifiedNameBuilder == null) {
                    return null;
                }
                StringBuilder builder = new StringBuilder();
                qualifiedNameBuilder.append(builder);
                this.qualifiedName = result = builder.toString();
            }
            return result;
        }
    }

    private static class VariableImpl
    extends VariableBase {
        VariableImpl(JsValue jsValue, WipExpressionBuilder.ValueNameBuilder nameBuilder) {
            super(jsValue, nameBuilder);
        }

        public JsObjectProperty asObjectProperty() {
            return null;
        }

        public JsDeclarativeVariable asDeclarativeVariable() {
            return null;
        }
    }
}

