/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.json;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.InitializeLaunchConfigurations;
import org.eclipse.wildwebdeveloper.json.JSonLanguageServerInterface;

public class JSonLanguageServer
extends ProcessStreamConnectionProvider {
    private static final String SCHEMA_EXT = "org.eclipse.wildwebdeveloper.json.schema";
    private static final String PATTERN_ATTR = "pattern";
    private static final String URL_ATTR = "url";

    public JSonLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(InitializeLaunchConfigurations.getNodeJsLocation());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/vscode-json-languageserver/dist/jsonServerMain.js"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getResult() instanceof InitializeResult) {
            JSonLanguageServerInterface server = (JSonLanguageServerInterface)languageServer;
            Map<String, List<String>> schemaAssociations = this.getSchemaAssociations();
            server.sendJSonchemaAssociations(schemaAssociations);
        }
    }

    private Map<String, List<String>> getSchemaAssociations() {
        HashMap<String, List<String>> associations = new HashMap<String, List<String>>();
        this.fillSchemaAssociationsForJavascript(associations);
        this.fillSchemaAssociationsForTypeScript(associations);
        this.fillSchemaAssociationsForOmnisharp(associations);
        this.fillSchemaAssociationsFromExtensionPoint(associations);
        return associations;
    }

    private void fillSchemaAssociationsForJavascript(Map<String, List<String>> associations) {
        associations.put("package.json", Arrays.asList("http://json.schemastore.org/package"));
        associations.put("/bower.json", Arrays.asList("http://json.schemastore.org/bower"));
        associations.put("/.bower.json", Arrays.asList("http://json.schemastore.org/bower"));
        associations.put("/.bowerrc", Arrays.asList("http://json.schemastore.org/bowerrc"));
        associations.put("/jsconfig.json", Arrays.asList("http://json.schemastore.org/jsconfig"));
        associations.put("/.eslintrc", Arrays.asList("http://json.schemastore.org/eslintrc"));
    }

    private void fillSchemaAssociationsForTypeScript(Map<String, List<String>> associations) {
        associations.put("/tsconfig.json", Arrays.asList("http://json.schemastore.org/tsconfig"));
        associations.put("/tsconfig.*.json", Arrays.asList("http://json.schemastore.org/tsconfig"));
        associations.put("/typing.json", Arrays.asList("http://json.schemastore.org/typing"));
    }

    private void fillSchemaAssociationsForOmnisharp(Map<String, List<String>> associations) {
        associations.put("/omnisharp.json", Arrays.asList("http://json.schemastore.org/omnisharp"));
    }

    private void fillSchemaAssociationsFromExtensionPoint(Map<String, List<String>> associations) {
        IConfigurationElement[] conf;
        IConfigurationElement[] iConfigurationElementArray = conf = Platform.getExtensionRegistry().getConfigurationElementsFor(SCHEMA_EXT);
        int n = conf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String pattern = el.getAttribute(PATTERN_ATTR);
            if (!associations.containsKey(pattern)) {
                associations.put(pattern, new ArrayList());
            }
            associations.get(pattern).add(el.getAttribute(URL_ATTR));
            ++n2;
        }
    }

    public Object getInitializationOptions(URI rootUri) {
        return Collections.singletonMap("provideFormatter", true);
    }
}

