/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.utils.ImageManager;
import org.eclipse.rcptt.ui.verification.VerificationUIManager;
import org.eclipse.rcptt.ui.wizards.WizardExecutablePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class WizardVerificationPage
extends WizardExecutablePage {
    private ImageManager imageManager = new ImageManager();
    private VerificationType type;
    private String name;
    private boolean takeSnapshot = false;
    private final VerificationType targetType;
    private final String widgetClass;

    public WizardVerificationPage(IStructuredSelection selection, VerificationType targetType, String widgetClass) {
        super("Verification", Messages.WizardVerificationPage_Title, selection);
        this.targetType = targetType;
        this.widgetClass = widgetClass;
    }

    public boolean takeSnapshot() {
        return this.takeSnapshot;
    }

    public void setTakeSnapshot(boolean takeSnapshot) {
        this.takeSnapshot = takeSnapshot;
    }

    @Override
    protected void createContent(Composite parent) {
        VerificationType[] types;
        Label label = new Label(parent, 16384);
        label.setText(Messages.WizardVerificationPage_NameLabel);
        final Text text = new Text(parent, 2048);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardVerificationPage.this.name = text.getText();
                WizardVerificationPage.this.validate();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)text);
        final Table table = new Table(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 2).applyTo((Control)table);
        VerificationType[] verificationTypeArray = types = VerificationTypeManager.getInstance().getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            VerificationType type = verificationTypeArray[n2];
            if ((!this.takeSnapshot || type.canCreate()) && type.canMake() && (this.widgetClass == null || type.supportsWidget(this.widgetClass))) {
                TableItem item = new TableItem(table, 0);
                item.setText(type.getName());
                item.setData((Object)type);
                ImageDescriptor descriptor = VerificationUIManager.getInstance().getIcon(type);
                if (descriptor != null) {
                    item.setImage(this.imageManager.getImage(descriptor));
                }
            }
            ++n2;
        }
        verificationTypeArray = table.getItems();
        n = verificationTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            VerificationType i = verificationTypeArray[n2];
            if (i.getData() == this.targetType) {
                table.setSelection((TableItem)i);
                this.type = this.targetType;
            }
            ++n2;
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table.getSelection();
                if (items.length > 0) {
                    WizardVerificationPage.this.type = (VerificationType)items[0].getData();
                } else {
                    WizardVerificationPage.this.type = null;
                }
                WizardVerificationPage.this.validate();
            }
        });
        if (this.targetType == null && table.getItemCount() > 0) {
            table.select(0);
            this.type = (VerificationType)table.getItem(0).getData();
        }
        text.setFocus();
    }

    @Override
    protected boolean doValidate() {
        if (super.doValidate()) {
            IQ7NamedElement[] elements;
            if (this.type == null) {
                this.setErrorMessage(Messages.WizardVerificationPage_NoTypeSelectedMsg);
                return false;
            }
            if (this.name == null || !Path.EMPTY.isValidSegment(this.name)) {
                this.setErrorMessage(Messages.WizardVerificationPage_EmptyNameMsg);
                return false;
            }
            IQ7NamedElement[] iQ7NamedElementArray = elements = Q7SearchCore.findByName((String)this.name, (ISearchScope)new ReferencedProjectScope(RcpttCore.create((IProject)this.getProject())), (IProgressMonitor)new NullProgressMonitor());
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
                if (iq7NamedElement instanceof IContext) {
                    this.setErrorMessage(Messages.WizardVerificationPage_DuplicateMsg);
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String getVerificationName() {
        return this.name;
    }

    @Override
    protected String getDefaultMessage() {
        return this.type.getDescription();
    }

    public VerificationType getVerificationType() {
        return this.type;
    }

    public void dispose() {
        super.dispose();
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }
}

