/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.actions;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public abstract class AbstractVMBreakpointPropertiesHandler
extends AbstractHandler {
    protected @Nullable VMLineBreakpoint getBreakpoint(@NonNull ExecutionEvent event) {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editorPart instanceof ITextEditor)) {
            return (VMLineBreakpoint)this.popUpError(event, "No ITextEditor", null);
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)editorPart.getAdapter(IVerticalRulerInfo.class);
        if (rulerInfo == null) {
            return (VMLineBreakpoint)this.popUpError(event, "No IVerticalRulerInfo", null);
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        IEditorInput editorInput = textEditor.getEditorInput();
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)editorInput);
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annot = (Annotation)iterator.next();
                if (!(annot instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)annot;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != rulerInfo.getLineOfLastMouseButtonActivity() || !((breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) instanceof VMLineBreakpoint)) continue;
                    return (VMLineBreakpoint)breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return (VMLineBreakpoint)this.popUpError(event, "No VMLineBreakpoint at selection", null);
    }

    protected <T> @Nullable T popUpError(@NonNull ExecutionEvent event, @NonNull String message, @Nullable IStatus s) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell != null) {
            DebugVMUIPlugin.errorDialog(shell, "Error", message, s);
        }
        return null;
    }
}

