/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.parsley.dsl.model.BindingsSpecification;
import org.eclipse.emf.parsley.dsl.model.Configurator;
import org.eclipse.emf.parsley.dsl.model.DialogControlFactory;
import org.eclipse.emf.parsley.dsl.model.DialogFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.FeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.FeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.FormControlFactory;
import org.eclipse.emf.parsley.dsl.model.FormFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.LabelProvider;
import org.eclipse.emf.parsley.dsl.model.MenuBuilder;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.ProposalCreator;
import org.eclipse.emf.parsley.dsl.model.ResourceManager;
import org.eclipse.emf.parsley.dsl.model.TableFeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.TableLabelProvider;
import org.eclipse.emf.parsley.dsl.model.TableViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.ViewerContentProvider;
import org.eclipse.emf.parsley.dsl.services.EmfParsleyDslGrammarAccess;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImages2;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;

/**
 * Provides labels for a EObjects.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#labelProvider
 */
@SuppressWarnings("all")
public class EmfParsleyDslLabelProvider extends XbaseLabelProvider {
  @Inject
  private EmfParsleyDslGrammarAccess g;
  
  @Inject
  private XbaseImages2 images;
  
  @Inject
  public EmfParsleyDslLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }
  
  public String text(final BindingsSpecification e) {
    return this.g.getBindingsSpecificationAccess().getBindingsKeyword_1().getValue();
  }
  
  public String text(final LabelProvider e) {
    return this.g.getLabelProviderAccess().getLabelProviderKeyword_1().getValue();
  }
  
  public String text(final TableLabelProvider e) {
    return this.g.getTableLabelProviderAccess().getTableLabelProviderKeyword_1().getValue();
  }
  
  public String text(final FeatureCaptionProvider e) {
    return this.g.getFeatureCaptionProviderAccess().getFeatureCaptionProviderKeyword_1().getValue();
  }
  
  public String text(final FormFeatureCaptionProvider e) {
    return this.g.getFormFeatureCaptionProviderAccess().getFormFeatureCaptionProviderKeyword_1().getValue();
  }
  
  public String text(final DialogFeatureCaptionProvider e) {
    return this.g.getDialogFeatureCaptionProviderAccess().getDialogFeatureCaptionProviderKeyword_1().getValue();
  }
  
  public String text(final FeaturesProvider e) {
    return this.g.getFeaturesProviderAccess().getFeaturesProviderKeyword_1().getValue();
  }
  
  public String text(final TableFeaturesProvider e) {
    return this.g.getTableFeaturesProviderAccess().getTableFeaturesProviderKeyword_1().getValue();
  }
  
  public String text(final FormControlFactory e) {
    return this.g.getFormControlFactoryAccess().getFormControlFactoryKeyword_1().getValue();
  }
  
  public String text(final DialogControlFactory e) {
    return this.g.getDialogControlFactoryAccess().getDialogControlFactoryKeyword_1().getValue();
  }
  
  public String text(final ProposalCreator e) {
    return this.g.getProposalCreatorAccess().getProposalsKeyword_1().getValue();
  }
  
  public String text(final MenuBuilder e) {
    return this.g.getMenuBuilderAccess().getMenuBuilderKeyword_1().getValue();
  }
  
  public String text(final Configurator e) {
    return this.g.getConfiguratorAccess().getConfiguratorKeyword_1().getValue();
  }
  
  public String text(final ViewerContentProvider e) {
    return this.g.getViewerContentProviderAccess().getViewerContentProviderKeyword_1().getValue();
  }
  
  public String text(final TableViewerContentProvider e) {
    return this.g.getTableViewerContentProviderAccess().getTableViewerContentProviderKeyword_1().getValue();
  }
  
  public String text(final PartsSpecifications e) {
    return this.g.getPartsSpecificationsAccess().getPartsKeyword_1().getValue();
  }
  
  public String text(final ResourceManager e) {
    return this.g.getResourceManagerAccess().getResourceManagerKeyword_1().getValue();
  }
  
  public ImageDescriptor image(final EObject e) {
    return this.images.forClass(JvmVisibility.PUBLIC, 0);
  }
}
