/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.unsupported;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.IFactory;
import org.eclipse.bpel.validator.model.Validator;

public class Factory
implements IFactory<Validator> {
    static final String PACKAGE_NAME = Factory.class.getPackage().getName();
    public static final IFactory<Validator> INSTANCE = new Factory();
    Logger mLogger = Logger.getLogger(this.getClass().getName());

    @Override
    public Validator create(QName qname) {
        String nsURI = qname.getNamespaceURI();
        if (nsURI.equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable") || nsURI.equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/")) {
            return null;
        }
        return this.createValidator(qname.getLocalPart());
    }

    Validator createValidator(String nodeName) {
        Object obj;
        Class<?> clazz;
        String name = String.valueOf(Character.toUpperCase(nodeName.charAt(0))) + nodeName.substring(1);
        String validatorClass = String.valueOf(PACKAGE_NAME) + "." + name;
        try {
            clazz = Class.forName(validatorClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Exception ex) {
            this.mLogger.log(Level.WARNING, "Validator class cannot be created.", ex);
            return null;
        }
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        this.mLogger.log(Level.WARNING, "Object is {0} is not a validator", obj);
        return null;
    }
}

