/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ByteFloatPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteFloatMaps;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.FloatByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ByteFloatHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableByteFloatSingletonMap
implements ImmutableByteFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    private final byte key1;
    private final float value1;

    ImmutableByteFloatSingletonMap(byte key1, float value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public float get(byte key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(byte key, float ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public float getOrThrow(byte key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key) {
        return this.key1 == key;
    }

    public boolean containsValue(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    public void forEachValue(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ByteProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ByteFloatProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyByteIterable keysView() {
        return ByteLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ByteFloatPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableFloatByteMap flipUniqueValues() {
        return FloatByteMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableByteFloatMap select(ByteFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ByteFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ByteFloatHashMap().toImmutable();
    }

    public ImmutableByteFloatMap reject(ByteFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ByteFloatHashMap().toImmutable() : ByteFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new FloatIterable[]{FloatBags.immutable.with(this.value1)});
    }

    public ImmutableByteFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)ByteFloatHashMap.newWithKeysValues(this.key1, this.value1).floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum() {
        return this.value1;
    }

    public float min() {
        return this.value1;
    }

    public float max() {
        return this.value1;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.value1;
    }

    public float minIfEmpty(float defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public float[] toSortedArray() {
        return new float[]{this.value1};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableFloatBag select(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatHashBag.newBagWith(this.value1).toImmutable() : FloatBags.immutable.empty();
    }

    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatBags.immutable.empty() : FloatHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public float[] toArray() {
        return new float[]{this.value1};
    }

    public float[] toArray(float[] target) {
        if (target.length < 1) {
            target = new float[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.value1);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.value1);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.value1);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableByteFloatMap newWithKeyValue(byte key, float value) {
        return ByteFloatMaps.immutable.withAll((ByteFloatMap)ByteFloatHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableByteFloatMap newWithoutKey(byte key) {
        return this.key1 == key ? ByteFloatMaps.immutable.with() : this;
    }

    public ImmutableByteFloatMap newWithoutAllKeys(ByteIterable keys) {
        return keys.contains(this.key1) ? ByteFloatMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(ByteHashSet.newSetWith(this.key1));
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of((MutableFloatCollection)FloatArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteFloatMap)) {
            return false;
        }
        ByteFloatMap map = (ByteFloatMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Float.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    public int hashCode() {
        return this.key1 ^ Float.floatToIntBits(this.value1);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

