/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public class IrValues
extends IrNode {
    private final List<String> varNames = new ArrayList<String>();
    private final List<List<String>> rows = new ArrayList<List<String>>();

    public IrValues(boolean newScope) {
        super(newScope);
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    @Override
    public void print(IrPrinter p) {
        if (this.varNames.isEmpty()) {
            p.line("VALUES () {");
            p.pushIndent();
            for (int i = 0; i < this.rows.size(); ++i) {
                p.line("()");
            }
            p.popIndent();
            p.line("}");
            return;
        }
        if (this.varNames.size() == 1) {
            String var = this.varNames.get(0);
            StringBuilder sb = new StringBuilder();
            sb.append("VALUES ?").append(var).append(" { ");
            for (int r = 0; r < this.rows.size(); ++r) {
                List<String> row;
                if (r > 0) {
                    sb.append(' ');
                }
                sb.append((row = this.rows.get(r)).isEmpty() ? "UNDEF" : row.get(0));
            }
            sb.append(" }");
            p.line(sb.toString());
            return;
        }
        StringBuilder head = new StringBuilder();
        head.append("VALUES (");
        for (int i = 0; i < this.varNames.size(); ++i) {
            if (i > 0) {
                head.append(' ');
            }
            head.append('?').append(this.varNames.get(i));
        }
        head.append(") {");
        p.line(head.toString());
        p.pushIndent();
        for (List<String> row : this.rows) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            if (row.isEmpty()) {
                sb.append("UNDEF");
            } else {
                for (int i = 0; i < row.size(); ++i) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(row.get(i));
                }
            }
            sb.append(')');
            p.line(sb.toString());
        }
        p.popIndent();
        p.line("}");
    }
}

