/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.AbstractValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.DecimalLiteral;
import org.eclipse.rdf4j.model.impl.GenericStatement;
import org.eclipse.rdf4j.model.impl.IntegerLiteral;
import org.eclipse.rdf4j.model.impl.NumericLiteral;
import org.eclipse.rdf4j.model.impl.SimpleBNode;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.model.impl.SimpleTriple;

public class SimpleValueFactory
extends AbstractValueFactory {
    private static final SimpleValueFactory sharedInstance = new SimpleValueFactory();
    private static final String uniqueIdPrefix = UUID.randomUUID().toString().replace("-", "");
    private static final AtomicLong uniqueIdSuffix = new AtomicLong();
    private static final String[] RANDOMIZE_LENGTH = new String[10];
    private static final DatatypeFactory datatypeFactory;

    public static SimpleValueFactory getInstance() {
        return sharedInstance;
    }

    protected SimpleValueFactory() {
    }

    public IRI createIRI(String iri) {
        return new SimpleIRI(iri);
    }

    public IRI createIRI(String namespace, String localName) {
        return new SimpleIRI(namespace, localName);
    }

    public BNode createBNode(String nodeID) {
        return new SimpleBNode(nodeID);
    }

    public Literal createLiteral(String value) {
        return new SimpleLiteral(value, (CoreDatatype)CoreDatatype.XSD.STRING);
    }

    public Literal createLiteral(String value, String language) {
        return new SimpleLiteral(value, language);
    }

    public Literal createLiteral(boolean b) {
        return b ? BooleanLiteral.TRUE : BooleanLiteral.FALSE;
    }

    public Literal createLiteral(String value, IRI datatype) {
        return new SimpleLiteral(value, datatype);
    }

    public Statement createStatement(Resource subject, IRI predicate, Value object) {
        return new GenericStatement<Object, IRI, Value>(subject, predicate, object, null);
    }

    public Statement createStatement(Resource subject, IRI predicate, Value object, Resource context) {
        return new GenericStatement<Resource, IRI, Value>(subject, predicate, object, context);
    }

    public Triple createTriple(Resource subject, IRI predicate, Value object) {
        return new SimpleTriple(subject, predicate, object);
    }

    public BNode createBNode() {
        long l = uniqueIdSuffix.incrementAndGet();
        StringBuilder sb = new StringBuilder(Long.toString(l));
        sb.reverse();
        sb.append(uniqueIdPrefix).append(RANDOMIZE_LENGTH[(int)Math.abs(l % (long)RANDOMIZE_LENGTH.length)]);
        return this.createBNode(sb.toString());
    }

    public Literal createLiteral(byte value) {
        return this.createIntegerLiteral((Number)value, CoreDatatype.XSD.BYTE);
    }

    public Literal createLiteral(short value) {
        return this.createIntegerLiteral((Number)value, CoreDatatype.XSD.SHORT);
    }

    public Literal createLiteral(int value) {
        return this.createIntegerLiteral((Number)value, CoreDatatype.XSD.INT);
    }

    public Literal createLiteral(long value) {
        return this.createIntegerLiteral((Number)value, CoreDatatype.XSD.LONG);
    }

    public Literal createLiteral(long value, CoreDatatype.XSD xsd) {
        assert (xsd.isIntegerDatatype());
        return this.createIntegerLiteral((Number)value, xsd);
    }

    protected Literal createIntegerLiteral(Number value, IRI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createIntegerLiteral(Number value, CoreDatatype.XSD datatype) {
        return this.createNumericLiteral(value, (CoreDatatype)datatype);
    }

    public Literal createLiteral(float value) {
        return this.createFPLiteral((Number)Float.valueOf(value), CoreDatatype.XSD.FLOAT);
    }

    public Literal createLiteral(double value) {
        return this.createFPLiteral((Number)value, CoreDatatype.XSD.DOUBLE);
    }

    public Literal createLiteral(BigInteger bigInteger) {
        return this.createIntegerLiteral((Number)bigInteger, CoreDatatype.XSD.INTEGER);
    }

    public Literal createLiteral(BigDecimal bigDecimal) {
        return this.createNumericLiteral((Number)bigDecimal, (CoreDatatype)CoreDatatype.XSD.DECIMAL);
    }

    protected Literal createFPLiteral(Number value, IRI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createFPLiteral(Number value, CoreDatatype.XSD datatype) {
        return this.createNumericLiteral(value, (CoreDatatype)datatype);
    }

    protected Literal createNumericLiteral(Number number, IRI datatype) {
        if (number instanceof BigDecimal) {
            return new DecimalLiteral((BigDecimal)number, datatype);
        }
        if (number instanceof BigInteger) {
            return new IntegerLiteral((BigInteger)number, datatype);
        }
        return new NumericLiteral(number, datatype);
    }

    protected Literal createNumericLiteral(Number number, CoreDatatype datatype) {
        if (number instanceof BigDecimal) {
            return new DecimalLiteral((BigDecimal)number, datatype);
        }
        if (number instanceof BigInteger) {
            return new IntegerLiteral((BigInteger)number, datatype);
        }
        return new NumericLiteral(number, datatype);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.createLiteral(calendar.toXMLFormat(), (CoreDatatype)XMLDatatypeUtil.qnameToCoreDatatype(calendar.getXMLSchemaType()));
    }

    public Literal createLiteral(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar xmlGregCalendar = datatypeFactory.newXMLGregorianCalendar(c);
        return this.createLiteral(xmlGregCalendar);
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 9; ++i) {
            SimpleValueFactory.RANDOMIZE_LENGTH[i] = sb.toString();
            sb.append(i);
        }
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error("Could not instantiate javax.xml.datatype.DatatypeFactory", e);
        }
    }
}

