/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.api;

import jakarta.json.JsonArray;
import java.net.URI;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.JsonLdVersion;
import no.hasmac.jsonld.api.CommonApi;
import no.hasmac.jsonld.api.LoaderApi;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.loader.DocumentLoader;
import no.hasmac.jsonld.processor.FromRdfProcessor;

public final class FromRdfApi
implements CommonApi<FromRdfApi>,
LoaderApi<FromRdfApi> {
    private final Document document;
    private final URI documentUri;
    private JsonLdOptions options;

    public FromRdfApi(Document document) {
        this.document = document;
        this.documentUri = null;
        this.options = new JsonLdOptions();
    }

    public FromRdfApi(URI documentUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.options = new JsonLdOptions();
    }

    @Override
    public FromRdfApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public FromRdfApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public FromRdfApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    @Override
    public FromRdfApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    @Override
    public FromRdfApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    public FromRdfApi nativeTypes() {
        return this.nativeTypes(true);
    }

    public FromRdfApi nativeTypes(boolean useNativeTypes) {
        this.options.setUseNativeTypes(useNativeTypes);
        return this;
    }

    public JsonArray get() throws JsonLdError {
        if (this.document != null) {
            return FromRdfProcessor.fromRdf(this.document, this.options);
        }
        if (this.documentUri != null) {
            return FromRdfProcessor.fromRdf(this.documentUri, this.options);
        }
        throw new IllegalStateException();
    }
}

