/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.btree;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.nativerdf.ConcurrentCache;
import org.eclipse.rdf4j.sail.nativerdf.btree.Node;

class ConcurrentNodeCache
extends ConcurrentCache<Integer, Node> {
    private final Function<Integer, Node> reader;
    private static final Consumer<Node> writeNode = node -> {
        if (node.dataChanged()) {
            try {
                node.write();
            }
            catch (IOException exc) {
                throw new SailException("Error writing B-tree node", exc);
            }
        }
    };

    public ConcurrentNodeCache(Function<Integer, Node> reader) {
        super(0);
        this.reader = reader;
    }

    public void flush() {
        this.cache.forEachValue(Long.MAX_VALUE, writeNode);
    }

    public void put(Node node) throws IOException {
        this.cache.put(node.getID(), node);
    }

    public Node readAndUse(int id) {
        return this.cache.compute(id, (k, v) -> {
            Node node = v == null ? this.reader.apply((Integer)k) : v;
            node.use();
            return node;
        });
    }

    public boolean discardEmptyUnused(int nodeId) {
        Node nn = this.cache.computeIfPresent(nodeId, (k, v) -> {
            if (v.getUsageCount() == 0 && v.isEmpty() && v.isLeaf()) {
                writeNode.accept((Node)v);
                return null;
            }
            return v;
        });
        return nn == null;
    }

    public void release(Node node, boolean forceSync) {
        if (forceSync) {
            writeNode.accept(node);
        }
        this.cleanUp();
    }

    @Override
    protected boolean onEntryRemoval(Integer key) {
        Node node = (Node)this.cache.get(key);
        if (node == null) {
            return true;
        }
        if (node.getUsageCount() > 0) {
            return false;
        }
        writeNode.accept(node);
        return true;
    }
}

