/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import java.io.File;
import org.eclipse.rdf4j.federated.FedXFactory;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConfig;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;

public class FedXRepositoryWrapper
extends RepositoryWrapper
implements RepositoryResolverClient,
FederatedServiceResolverClient {
    private final FedXRepositoryConfig fedXConfig;
    private File dataDir;
    private RepositoryResolver repositoryResolver;
    private FederatedServiceResolver serviceResolver;

    public FedXRepositoryWrapper(FedXRepositoryConfig fedXConfig) {
        this.fedXConfig = fedXConfig;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public boolean isInitialized() {
        if (this.getDelegate() == null) {
            return false;
        }
        return super.isInitialized();
    }

    public void init() throws RepositoryException {
        FedXRepository fedxRepo;
        if (this.getDelegate() != null) {
            return;
        }
        try {
            FedXFactory factory = this.createFactory();
            fedxRepo = factory.create();
            fedxRepo.init();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        this.setDelegate((Repository)fedxRepo);
    }

    protected FedXFactory createFactory() {
        File baseDir = this.getDataDir();
        if (baseDir == null) {
            baseDir = new File(".");
        }
        Model members = this.fedXConfig.getMembers();
        File dataConfigFile = null;
        if (this.fedXConfig.getDataConfig() != null) {
            dataConfigFile = new File(baseDir, this.fedXConfig.getDataConfig());
        }
        if (members == null && dataConfigFile == null) {
            throw new RepositoryException("No federation members defined: neither explicitly nor via data config.");
        }
        FedXFactory factory = FedXFactory.newFederation().withRepositoryResolver(this.repositoryResolver).withFederatedServiceResolver(this.serviceResolver).withFedXBaseDir(baseDir);
        if (dataConfigFile != null) {
            factory.withMembers(dataConfigFile);
        }
        if (members != null) {
            factory.withMembers(members);
        }
        if (this.fedXConfig.getConfig() != null) {
            factory.withConfig(this.fedXConfig.getConfig());
        }
        return factory;
    }

    public void shutDown() throws RepositoryException {
        if (!this.isInitialized()) {
            return;
        }
        super.shutDown();
        this.setDelegate(null);
    }

    public void setRepositoryResolver(RepositoryResolver resolver) {
        this.repositoryResolver = resolver;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }
}

