/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.platform.support;

import java.io.File;
import org.eclipse.rdf4j.common.platform.AbstractPlatform;

public class WindowsPlatform
extends AbstractPlatform {
    public static final String APPLICATION_DATA = "Application Data";
    public static final String ADUNA_APPLICATION_DATA = "RDF4J";

    @Override
    public String getName() {
        return "Windows";
    }

    @Override
    public File getUserHome() {
        File result = super.getUserHome();
        String homeDrive = System.getenv("HOMEDRIVE");
        String homePath = System.getenv("HOMEPATH");
        if (homeDrive != null && homePath != null) {
            File homeDir = new File(homeDrive + homePath);
            if (homeDir.isDirectory() && homeDir.canWrite()) {
                result = homeDir;
            }
        } else {
            File userProfileDir;
            String userProfile = System.getenv("USERPROFILE");
            if (userProfile != null && (userProfileDir = new File(userProfile)).isDirectory() && userProfileDir.canWrite()) {
                result = userProfileDir;
            }
        }
        return result;
    }

    @Override
    public File getOSApplicationDataDir() {
        File appDataDir;
        File result = new File(this.getUserHome(), APPLICATION_DATA);
        String appData = System.getenv("APPDATA");
        if (appData != null && (appDataDir = new File(appData)).isDirectory() && appDataDir.canWrite()) {
            result = appDataDir;
        }
        return new File(result, ADUNA_APPLICATION_DATA);
    }

    public String getCommandShell() {
        return "cmd";
    }

    @Override
    public boolean dataDirPreserveCase() {
        return true;
    }

    @Override
    public boolean dataDirReplaceWhitespace() {
        return false;
    }

    @Override
    public boolean dataDirReplaceColon() {
        return true;
    }
}

