/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.UUID;
import org.mapdb.CompressLZF;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.SerializerBase;

public interface Serializer<A> {
    public static final Serializer<String> STRING = new Serializer<String>(){

        @Override
        public void serialize(DataOutput out, String value) throws IOException {
            out.writeUTF(value);
        }

        @Override
        public String deserialize(DataInput in, int available) throws IOException {
            return in.readUTF();
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<String> STRING_INTERN = new Serializer<String>(){

        @Override
        public void serialize(DataOutput out, String value) throws IOException {
            out.writeUTF(value);
        }

        @Override
        public String deserialize(DataInput in, int available) throws IOException {
            return in.readUTF().intern();
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<String> STRING_ASCII = new Serializer<String>(){

        @Override
        public void serialize(DataOutput out, String value) throws IOException {
            char[] cc = new char[value.length()];
            value.getChars(0, cc.length, cc, 0);
            DataOutput2.packInt(out, cc.length);
            for (char c : cc) {
                out.write(c);
            }
        }

        @Override
        public String deserialize(DataInput in, int available) throws IOException {
            int size = DataInput2.unpackInt(in);
            char[] cc = new char[size];
            for (int i = 0; i < size; ++i) {
                cc[i] = (char)in.readUnsignedByte();
            }
            return new String(cc);
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<String> STRING_NOSIZE = new Serializer<String>(){
        private final Charset UTF8_CHARSET = Charset.forName("UTF8");

        @Override
        public void serialize(DataOutput out, String value) throws IOException {
            byte[] bytes = value.getBytes(this.UTF8_CHARSET);
            out.write(bytes);
        }

        @Override
        public String deserialize(DataInput in, int available) throws IOException {
            if (available == -1) {
                throw new IllegalArgumentException("STRING_NOSIZE does not work with collections.");
            }
            byte[] bytes = new byte[available];
            in.readFully(bytes);
            return new String(bytes, this.UTF8_CHARSET);
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<Long> LONG = new Serializer<Long>(){

        @Override
        public void serialize(DataOutput out, Long value) throws IOException {
            if (value != null) {
                out.writeLong(value);
            }
        }

        @Override
        public Long deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            return in.readLong();
        }

        @Override
        public int fixedSize() {
            return 8;
        }
    };
    public static final Serializer<Integer> INTEGER = new Serializer<Integer>(){

        @Override
        public void serialize(DataOutput out, Integer value) throws IOException {
            out.writeInt(value);
        }

        @Override
        public Integer deserialize(DataInput in, int available) throws IOException {
            return in.readInt();
        }

        @Override
        public int fixedSize() {
            return 4;
        }
    };
    public static final Serializer<Boolean> BOOLEAN = new Serializer<Boolean>(){

        @Override
        public void serialize(DataOutput out, Boolean value) throws IOException {
            out.writeBoolean(value);
        }

        @Override
        public Boolean deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            return in.readBoolean();
        }

        @Override
        public int fixedSize() {
            return 1;
        }
    };
    public static final Serializer<Object> ILLEGAL_ACCESS = new Serializer<Object>(){

        @Override
        public void serialize(DataOutput out, Object value) throws IOException {
            throw new IllegalAccessError();
        }

        @Override
        public Object deserialize(DataInput in, int available) throws IOException {
            throw new IllegalAccessError();
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<Object> BASIC = new SerializerBase();
    public static final Serializer<byte[]> BYTE_ARRAY = new Serializer<byte[]>(){

        @Override
        public void serialize(DataOutput out, byte[] value) throws IOException {
            DataOutput2.packInt(out, value.length);
            out.write(value);
        }

        @Override
        public byte[] deserialize(DataInput in, int available) throws IOException {
            int size = DataInput2.unpackInt(in);
            byte[] ret = new byte[size];
            in.readFully(ret);
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<byte[]> BYTE_ARRAY_NOSIZE = new Serializer<byte[]>(){

        @Override
        public void serialize(DataOutput out, byte[] value) throws IOException {
            if (value == null || value.length == 0) {
                return;
            }
            out.write(value);
        }

        @Override
        public byte[] deserialize(DataInput in, int available) throws IOException {
            if (available == -1) {
                throw new IllegalArgumentException("BYTE_ARRAY_NOSIZE does not work with collections.");
            }
            if (available == 0) {
                return null;
            }
            byte[] ret = new byte[available];
            in.readFully(ret);
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<char[]> CHAR_ARRAY = new Serializer<char[]>(){

        @Override
        public void serialize(DataOutput out, char[] value) throws IOException {
            DataOutput2.packInt(out, value.length);
            for (char c : value) {
                out.writeChar(c);
            }
        }

        @Override
        public char[] deserialize(DataInput in, int available) throws IOException {
            int size = DataInput2.unpackInt(in);
            char[] ret = new char[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = in.readChar();
            }
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<int[]> INT_ARRAY = new Serializer<int[]>(){

        @Override
        public void serialize(DataOutput out, int[] value) throws IOException {
            DataOutput2.packInt(out, value.length);
            for (int c : value) {
                out.writeInt(c);
            }
        }

        @Override
        public int[] deserialize(DataInput in, int available) throws IOException {
            int size = DataInput2.unpackInt(in);
            int[] ret = new int[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = in.readInt();
            }
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<long[]> LONG_ARRAY = new Serializer<long[]>(){

        @Override
        public void serialize(DataOutput out, long[] value) throws IOException {
            DataOutput2.packInt(out, value.length);
            for (long c : value) {
                out.writeLong(c);
            }
        }

        @Override
        public long[] deserialize(DataInput in, int available) throws IOException {
            int size = DataInput2.unpackInt(in);
            long[] ret = new long[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = in.readLong();
            }
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<double[]> DOUBLE_ARRAY = new Serializer<double[]>(){

        @Override
        public void serialize(DataOutput out, double[] value) throws IOException {
            DataOutput2.packInt(out, value.length);
            for (double c : value) {
                out.writeDouble(c);
            }
        }

        @Override
        public double[] deserialize(DataInput in, int available) throws IOException {
            int size = DataInput2.unpackInt(in);
            double[] ret = new double[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = in.readDouble();
            }
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<Object> JAVA = new Serializer<Object>(){

        @Override
        public void serialize(DataOutput out, Object value) throws IOException {
            ObjectOutputStream out2 = new ObjectOutputStream((OutputStream)((Object)out));
            out2.writeObject(value);
            out2.flush();
        }

        @Override
        public Object deserialize(DataInput in, int available) throws IOException {
            try {
                ObjectInputStream in2 = new ObjectInputStream((InputStream)((Object)in));
                return in2.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    public static final Serializer<UUID> UUID = new Serializer<UUID>(){

        @Override
        public void serialize(DataOutput out, UUID value) throws IOException {
            out.writeLong(value.getMostSignificantBits());
            out.writeLong(value.getLeastSignificantBits());
        }

        @Override
        public UUID deserialize(DataInput in, int available) throws IOException {
            return new UUID(in.readLong(), in.readLong());
        }

        @Override
        public int fixedSize() {
            return 16;
        }
    };

    public void serialize(DataOutput var1, A var2) throws IOException;

    public A deserialize(DataInput var1, int var2) throws IOException;

    public int fixedSize();

    public static final class CompressionWrapper<E>
    implements Serializer<E>,
    Serializable {
        private static final long serialVersionUID = 4440826457939614346L;
        protected final Serializer<E> serializer;
        protected final ThreadLocal<CompressLZF> LZF = new ThreadLocal<CompressLZF>(){

            @Override
            protected CompressLZF initialValue() {
                return new CompressLZF();
            }
        };

        public CompressionWrapper(Serializer<E> serializer) {
            this.serializer = serializer;
        }

        protected CompressionWrapper(SerializerBase serializerBase, DataInput is, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.serializer = (Serializer)serializerBase.deserialize(is, objectStack);
        }

        @Override
        public void serialize(DataOutput out, E value) throws IOException {
            int newLen;
            DataOutput2 out2 = new DataOutput2();
            this.serializer.serialize(out2, value);
            byte[] tmp = new byte[out2.pos + 41];
            try {
                newLen = this.LZF.get().compress(out2.buf, out2.pos, tmp, 0);
            }
            catch (IndexOutOfBoundsException e) {
                newLen = 0;
            }
            if (newLen >= out2.pos) {
                DataOutput2.packInt(out, 0);
                out.write(out2.buf, 0, out2.pos);
                return;
            }
            DataOutput2.packInt(out, out2.pos + 1);
            out.write(tmp, 0, newLen);
        }

        @Override
        public E deserialize(DataInput in, int available) throws IOException {
            int unpackedSize = DataInput2.unpackInt(in) - 1;
            if (unpackedSize == -1) {
                return this.serializer.deserialize(in, available > 0 ? available - 1 : available);
            }
            byte[] unpacked = new byte[unpackedSize];
            this.LZF.get().expand(in, unpacked, 0, unpackedSize);
            DataInput2 in2 = new DataInput2(unpacked);
            E ret = this.serializer.deserialize(in2, unpackedSize);
            assert (in2.pos == unpackedSize) : "data were not fully read";
            return ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompressionWrapper that = (CompressionWrapper)o;
            return this.serializer.equals(that.serializer);
        }

        public int hashCode() {
            return this.serializer.hashCode();
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    }
}

