/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.VarNameCollector;

public class FilterOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new FilterUnMerger());
        tupleExpr.visit((QueryModelVisitor)new FilterOrganizer());
        tupleExpr.visit((QueryModelVisitor)new FilterMerger());
    }

    private static class FilterRelocator
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Filter filter;
        private final Set<String> filterVars;

        private FilterRelocator(Filter filter) {
            this.filter = filter;
            this.filterVars = VarNameCollector.process((QueryModelNode)filter.getCondition());
        }

        public static void optimize(Filter filter) {
            filter.visit((QueryModelVisitor)new FilterRelocator(filter));
        }

        protected void meetNode(QueryModelNode node) {
            assert (node instanceof TupleExpr);
            this.relocate(this.filter, (TupleExpr)node);
        }

        public void meet(Join join) {
            if (join.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                join.getLeftArg().visit((QueryModelVisitor)this);
            } else if (join.getRightArg().getBindingNames().containsAll(this.filterVars)) {
                join.getRightArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, (TupleExpr)join);
            }
        }

        public void meet(StatementPattern sp) {
            if (sp.getBindingNames().containsAll(this.filterVars)) {
                this.relocate(this.filter, (TupleExpr)sp);
            }
        }

        public void meet(LeftJoin leftJoin) {
            if (leftJoin.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                leftJoin.getLeftArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, (TupleExpr)leftJoin);
            }
        }

        public void meet(Union union) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, union.getLeftArg());
            this.relocate(clone, union.getRightArg());
            FilterRelocator.optimize(this.filter);
            FilterRelocator.optimize(clone);
        }

        public void meet(Difference node) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node.getLeftArg());
            this.relocate(clone, node.getRightArg());
            FilterRelocator.optimize(this.filter);
            FilterRelocator.optimize(clone);
        }

        public void meet(Intersection node) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node.getLeftArg());
            this.relocate(clone, node.getRightArg());
            FilterRelocator.optimize(this.filter);
            FilterRelocator.optimize(clone);
        }

        public void meet(Extension node) {
            if (node.getArg().getBindingNames().containsAll(this.filterVars)) {
                node.getArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, (TupleExpr)node);
            }
        }

        public void meet(EmptySet node) {
            if (this.filter.getParentNode() != null) {
                this.filter.replaceWith((QueryModelNode)this.filter.getArg().clone());
            }
        }

        public void meet(Filter filter) {
            filter.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Distinct node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Order node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(QueryRoot node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Reduced node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        private void relocate(Filter filter, TupleExpr newFilterArg) {
            if (filter.getArg() != newFilterArg) {
                if (filter.getParentNode() != null) {
                    filter.replaceWith((QueryModelNode)filter.getArg());
                }
                newFilterArg.replaceWith((QueryModelNode)filter);
                filter.setArg(newFilterArg);
            }
        }
    }

    private static class FilterOrganizer
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        public FilterOrganizer() {
            super(false);
        }

        public void meet(Filter filter) {
            super.meet(filter);
            FilterRelocator.optimize(filter);
        }
    }

    private static class FilterMerger
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private FilterMerger() {
            super(false);
        }

        public void meet(Filter filter) {
            super.meet(filter);
            if (filter.getParentNode() instanceof Filter && filter.getParentNode().getParentNode() != null) {
                Filter parentFilter = (Filter)filter.getParentNode();
                QueryModelNode grandParent = parentFilter.getParentNode();
                And merge = new And(filter.getCondition().clone(), parentFilter.getCondition().clone());
                Filter newFilter = new Filter(filter.getArg().clone(), (ValueExpr)merge);
                grandParent.replaceChildNode((QueryModelNode)parentFilter, (QueryModelNode)newFilter);
                this.meet(newFilter);
            }
        }
    }

    private static class FilterUnMerger
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private FilterUnMerger() {
            super(false);
        }

        public void meet(Filter filter) {
            if (filter.getCondition() instanceof And) {
                And and = (And)filter.getCondition();
                filter.setCondition(and.getLeftArg().clone());
                Filter newFilter = new Filter(filter.getArg().clone(), and.getRightArg().clone());
                filter.replaceChildNode((QueryModelNode)filter.getArg(), (QueryModelNode)newFilter);
            }
            super.meet(filter);
        }
    }
}

