/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core;

import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.StandardQueryElementCollection;

public class PrefixDeclarations
extends StandardQueryElementCollection<Prefix> {
    public PrefixDeclarations addPrefix(Prefix ... prefixes) {
        this.addElements(prefixes);
        return this;
    }

    public String replacePrefixesInQuery(String queryString) {
        boolean isInsideDoubleQuotes = false;
        boolean isInsideMultlineQuotes = false;
        boolean isInsideString = false;
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int lastPos = 0;
        while (pos != -1 && pos < queryString.length() && (pos = this.findNextRelevantIndex(queryString, lastPos, isInsideString)) != -1 && pos < queryString.length() - 1) {
            sb.append(queryString, lastPos, pos);
            if (isInsideString) {
                if (this.isEscapeChar(queryString, pos)) {
                    sb.append(queryString, pos, pos + 2);
                    lastPos = pos += 2;
                    continue;
                }
                if (isInsideDoubleQuotes && this.isDoubleQuote(queryString, pos)) {
                    sb.append(queryString, pos, pos + 1);
                    isInsideString = false;
                    isInsideDoubleQuotes = false;
                    lastPos = ++pos;
                    continue;
                }
                if (isInsideMultlineQuotes && this.isMultilineQuote(queryString, pos)) {
                    sb.append(queryString, pos, pos + 3);
                    isInsideString = false;
                    isInsideMultlineQuotes = false;
                    lastPos = pos += 3;
                    continue;
                }
            } else {
                if (this.isDoubleQuote(queryString, pos)) {
                    sb.append(queryString, pos, pos + 1);
                    isInsideString = true;
                    isInsideDoubleQuotes = true;
                    lastPos = ++pos;
                    continue;
                }
                if (this.isMultilineQuote(queryString, pos)) {
                    sb.append(queryString, pos, pos + 3);
                    isInsideString = true;
                    isInsideMultlineQuotes = true;
                    lastPos = pos += 3;
                    continue;
                }
            }
            if (isInsideString) {
                sb.append(queryString, pos, pos + 1);
                lastPos = ++pos;
                continue;
            }
            if (this.isOpeningAngledBracket(queryString, pos)) {
                Prefix matchingPrefix = this.findMatchingPrefix(queryString, pos + 1);
                if (matchingPrefix != null) {
                    int posOfClosingBracket = queryString.indexOf(62, pos);
                    if (posOfClosingBracket > -1) {
                        int replacementLength = matchingPrefix.getIri().getQueryString().length() - 2;
                        sb.append(matchingPrefix.getLabel()).append(":").append(queryString, pos + 1 + replacementLength, posOfClosingBracket);
                        pos = posOfClosingBracket + 1;
                    }
                } else {
                    sb.append('<');
                }
            }
            lastPos = ++pos;
        }
        if (pos == -1) {
            sb.append(queryString.substring(lastPos));
        }
        return sb.toString();
    }

    private boolean isOpeningAngledBracket(String queryString, int pos) {
        return queryString.charAt(pos) == '<';
    }

    private boolean isMultilineQuote(String queryString, int pos) {
        return queryString.startsWith("'''", pos);
    }

    private boolean isEscapeChar(String queryString, int pos) {
        return queryString.charAt(pos) == '\\';
    }

    private boolean isDoubleQuote(String queryString, int pos) {
        return queryString.charAt(pos) == '\"';
    }

    private int findNextRelevantIndex(String queryString, int lastPos, boolean isInsideString) {
        int[] mins = new int[]{isInsideString ? -1 : queryString.indexOf(60, lastPos), isInsideString ? queryString.indexOf(92, lastPos) : -1, queryString.indexOf(34, lastPos), queryString.indexOf("'''", lastPos)};
        int min = Integer.MAX_VALUE;
        for (int j : mins) {
            if (j < 0) continue;
            min = Math.min(min, j);
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    private Prefix findMatchingPrefix(String queryString, int pos) {
        return this.elements.stream().filter(p -> queryString.startsWith(this.getIRIStringFromPrefix((Prefix)p), pos)).filter(p -> this.isContinuationALocalName(queryString.substring(pos + p.getIri().getQueryString().length() - 2))).reduce((r, l) -> r.getIri().getQueryString().length() > l.getIri().getQueryString().length() ? r : l).orElse(null);
    }

    private boolean isContinuationALocalName(String continuation) {
        String localNameCandiate = continuation.substring(0, this.findNextWhitespace(continuation));
        return URIUtil.isValidLocalName((String)localNameCandiate);
    }

    private int findNextWhitespace(String continuation) {
        char cur;
        int i;
        for (i = 0; i < continuation.length() && !Character.isWhitespace(cur = continuation.charAt(i)) && '>' != cur; ++i) {
        }
        return i;
    }

    private String getIRIStringFromPrefix(Prefix p) {
        return p.getIri().getQueryString().substring(1, p.getIri().getQueryString().length() - 1);
    }
}

