/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.http.protocol.transaction.TransactionWriter;
import org.eclipse.rdf4j.http.protocol.transaction.operations.TransactionOperation;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDF4JProtocolSession
extends SPARQLProtocolSession {
    private static final long PINGDELAY = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS) / 2L;
    private final Logger logger = LoggerFactory.getLogger(RDF4JProtocolSession.class);
    private String serverURL;
    private String transactionURL;
    private final ScheduledExecutorService pingScheduler;
    private ScheduledFuture<?> ping;
    private long pingDelay = PINGDELAY;

    @Deprecated
    public RDF4JProtocolSession(HttpClient client, ScheduledExecutorService executor) {
        this(client, (ExecutorService)executor);
    }

    public RDF4JProtocolSession(HttpClient client, ExecutorService executor) {
        super(client, executor);
        this.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        this.setPreferredTupleQueryResultFormat(TupleQueryResultFormat.BINARY);
        this.setPreferredRDFFormat(RDFFormat.BINARY);
        try {
            String configuredValue = System.getProperty("rdf4j.server.txn.registry.timeout");
            if (configuredValue != null) {
                int timeout = Integer.parseInt(configuredValue);
                this.pingDelay = TimeUnit.MILLISECONDS.convert(Math.max(timeout, 1), TimeUnit.SECONDS) / 2L;
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not read integer value of system property {}", (Object)"rdf4j.server.txn.registry.timeout");
        }
        this.pingScheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("rdf4j-pingScheduler");
            thread.setDaemon(true);
            return thread;
        });
    }

    public void setServerURL(String serverURL) {
        if (serverURL == null) {
            throw new IllegalArgumentException("serverURL must not be null");
        }
        this.serverURL = serverURL;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getRepositoryURL() {
        return this.getQueryURL();
    }

    public void setRepository(String repositoryURL) {
        Pattern urlPattern = Pattern.compile("(.*)/repositories/[^/]*/?");
        Matcher matcher = urlPattern.matcher(repositoryURL);
        if (matcher.matches() && matcher.groupCount() == 1) {
            this.setServerURL(matcher.group(1));
        }
        this.setQueryURL(repositoryURL);
    }

    protected void checkRepositoryURL() {
        if (this.getRepositoryURL() == null) {
            throw new IllegalStateException("Repository URL has not been set");
        }
    }

    protected void checkServerURL() {
        if (this.serverURL == null) {
            throw new IllegalStateException("Server URL has not been set");
        }
    }

    @Override
    public String getUpdateURL() {
        return Protocol.getStatementsLocation((String)this.getQueryURL());
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.transactionURL = null;
            if (this.ping != null) {
                this.ping.cancel(false);
                this.ping = null;
            }
            this.pingScheduler.shutdownNow();
        }
    }

    private synchronized String getTransactionURL() {
        return this.transactionURL;
    }

    public TupleQueryResult getRepositoryList() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getRepositoryList((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getRepositoryList(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkServerURL();
        HttpGet method = this.applyAdditionalHeaders(new HttpGet(Protocol.getRepositoriesLocation((String)this.serverURL)));
        try {
            this.getTupleQueryResult((HttpUriRequest)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public String getServerProtocol() throws IOException, RepositoryException, UnauthorizedException {
        this.checkServerURL();
        HttpGet method = this.applyAdditionalHeaders(new HttpGet(Protocol.getProtocolLocation((String)this.serverURL)));
        try {
            String string = EntityUtils.toString((HttpEntity)this.executeOK((HttpUriRequest)method).getEntity());
            return string;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long size(Resource ... contexts) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        try {
            String transactionURL = this.getTransactionURL();
            boolean useTransaction = transactionURL != null;
            String baseLocation = useTransaction ? this.appendAction(transactionURL, Protocol.Action.SIZE) : Protocol.getSizeLocation((String)this.getQueryURL());
            URIBuilder url = new URIBuilder(baseLocation);
            String[] encodedContexts = Protocol.encodeContexts((Resource[])contexts);
            for (int i = 0; i < encodedContexts.length; ++i) {
                url.addParameter("context", encodedContexts[i]);
            }
            HttpPut method = useTransaction ? new HttpPut(url.build()) : new HttpGet(url.build());
            this.applyAdditionalHeaders(method);
            try {
                String response = EntityUtils.toString((HttpEntity)this.executeOK((HttpUriRequest)method).getEntity());
                this.pingTransaction();
                try {
                    long l = Long.parseLong(response);
                    return l;
                }
                catch (NumberFormatException e) {
                    throw new RepositoryException("Server responded with invalid size value: " + response);
                }
            }
            finally {
                method.reset();
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void createRepository(RepositoryConfig config) throws IOException, RepositoryException {
        String baseURI = Protocol.getRepositoryLocation((String)this.serverURL, (String)config.getID());
        this.setRepository(baseURI);
        IRI ctx = SimpleValueFactory.getInstance().createIRI(baseURI + "#" + config.getID());
        LinkedHashModel model = new LinkedHashModel();
        config.export((Model)model, (Resource)ctx);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Rio.write((Iterable)model, (OutputStream)baos, (RDFFormat)this.getPreferredRDFFormat());
        HttpEntityEnclosingRequestBase method = null;
        try (ByteArrayInputStream contents = new ByteArrayInputStream(baos.toByteArray());){
            InputStreamEntity entity = new InputStreamEntity((InputStream)contents, -1L, ContentType.parse((String)this.getPreferredRDFFormat().getDefaultMIMEType()));
            method = (HttpEntityEnclosingRequestBase)this.applyAdditionalHeaders(new HttpPut(baseURI));
            method.setEntity((HttpEntity)entity);
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException | RDFParseException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.reset();
            }
        }
    }

    public void updateRepository(RepositoryConfig config) throws IOException, RepositoryException {
        String baseURI = Protocol.getRepositoryLocation((String)this.serverURL, (String)config.getID());
        this.setRepository(baseURI);
        IRI ctx = SimpleValueFactory.getInstance().createIRI(baseURI + "#" + config.getID());
        LinkedHashModel model = new LinkedHashModel();
        config.export((Model)model, (Resource)ctx);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Rio.write((Iterable)model, (OutputStream)baos, (RDFFormat)this.getPreferredRDFFormat());
        HttpEntityEnclosingRequestBase method = null;
        try (ByteArrayInputStream contents = new ByteArrayInputStream(baos.toByteArray());){
            InputStreamEntity entity = new InputStreamEntity((InputStream)contents, -1L, ContentType.parse((String)this.getPreferredRDFFormat().getDefaultMIMEType()));
            method = (HttpEntityEnclosingRequestBase)this.applyAdditionalHeaders(new HttpPost(Protocol.getRepositoryConfigLocation((String)baseURI)));
            method.setEntity((HttpEntity)entity);
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException | RDFParseException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.reset();
            }
        }
    }

    public void deleteRepository(String repositoryID) throws IOException, RepositoryException {
        HttpDelete method = this.applyAdditionalHeaders(new HttpDelete(Protocol.getRepositoryLocation((String)this.serverURL, (String)repositoryID)));
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public void getRepositoryConfig(StatementCollector statementCollector) throws UnauthorizedException, QueryInterruptedException, RDFHandlerException, RepositoryException, IOException {
        this.checkRepositoryURL();
        try {
            String baseLocation = Protocol.getRepositoryConfigLocation((String)this.getRepositoryURL());
            URIBuilder url = new URIBuilder(baseLocation);
            HttpGet method = new HttpGet(url.build());
            method = (HttpRequestBase)this.applyAdditionalHeaders(method);
            try {
                this.getRDF((HttpUriRequest)method, (RDFHandler)statementCollector, true);
            }
            catch (MalformedQueryException e) {
                this.logger.warn("Server reported unexpected malformed query error", (Throwable)e);
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            finally {
                method.reset();
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public TupleQueryResult getNamespaces() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getNamespaces((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        HttpGet method = this.applyAdditionalHeaders(new HttpGet(Protocol.getNamespacesLocation((String)this.getQueryURL())));
        try {
            this.getTupleQueryResult((HttpUriRequest)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public String getNamespace(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpGet method = this.applyAdditionalHeaders(new HttpGet(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix)));
        try {
            HttpResponse response = this.execute((HttpUriRequest)method);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200 || code == 203) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
            String string = null;
            return string;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public void setNamespacePrefix(String prefix, String name) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpPut method = this.applyAdditionalHeaders(new HttpPut(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix)));
        try {
            method.setEntity((HttpEntity)new StringEntity(name, ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public void removeNamespacePrefix(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpDelete method = this.applyAdditionalHeaders(new HttpDelete(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix)));
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public void clearNamespaces() throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpDelete method = this.applyAdditionalHeaders(new HttpDelete(Protocol.getNamespacesLocation((String)this.getQueryURL())));
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public TupleQueryResult getContextIDs() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getContextIDs((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        HttpGet method = this.applyAdditionalHeaders(new HttpGet(Protocol.getContextsLocation((String)this.getQueryURL())));
        try {
            this.getTupleQueryResult((HttpUriRequest)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        finally {
            method.reset();
        }
    }

    public void getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws IOException, RDFHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        try {
            String transactionURL = this.getTransactionURL();
            boolean useTransaction = transactionURL != null;
            String baseLocation = useTransaction ? transactionURL : Protocol.getStatementsLocation((String)this.getQueryURL());
            URIBuilder url = new URIBuilder(baseLocation);
            if (subj != null) {
                url.setParameter("subj", Protocol.encodeValue((Value)subj));
            }
            if (pred != null) {
                url.setParameter("pred", Protocol.encodeValue((Value)pred));
            }
            if (obj != null) {
                url.setParameter("obj", Protocol.encodeValue((Value)obj));
            }
            for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
                url.addParameter("context", encodedContext);
            }
            url.setParameter("infer", Boolean.toString(includeInferred));
            if (useTransaction) {
                url.setParameter("action", Protocol.Action.GET.toString());
            }
            HttpPut method = useTransaction ? new HttpPut(url.build()) : new HttpGet(url.build());
            method = (HttpRequestBase)this.applyAdditionalHeaders(method);
            try {
                this.getRDF((HttpUriRequest)method, handler, true);
            }
            catch (MalformedQueryException e) {
                this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            finally {
                method.reset();
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        this.pingTransaction();
    }

    public synchronized void beginTransaction(IsolationLevel isolationLevel) throws RDF4JException, IOException, UnauthorizedException {
        this.beginTransaction(new TransactionSetting[]{isolationLevel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginTransaction(TransactionSetting ... transactionSettings) throws RDF4JException, IOException, UnauthorizedException {
        block10: {
            this.checkRepositoryURL();
            if (this.transactionURL != null) {
                throw new IllegalStateException("Transaction URL is already set");
            }
            HttpPost method = this.applyAdditionalHeaders(new HttpPost(Protocol.getTransactionsLocation((String)this.getRepositoryURL())));
            try {
                method.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (TransactionSetting transactionSetting : transactionSettings) {
                    if (transactionSetting == null) continue;
                    params.add(new BasicNameValuePair("transaction-setting__" + transactionSetting.getName(), transactionSetting.getValue()));
                }
                method.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF8));
                HttpResponse response = this.execute((HttpUriRequest)method);
                try {
                    int code = response.getStatusLine().getStatusCode();
                    if (code == 201) {
                        this.transactionURL = response.getFirstHeader("Location").getValue();
                        if (this.transactionURL == null) {
                            throw new RepositoryException("no valid transaction ID received in server response.");
                        }
                        this.pingTransaction();
                        break block10;
                    }
                    throw new RepositoryException("unable to start transaction. HTTP error code " + code);
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            finally {
                method.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareTransaction() throws RDF4JException, IOException, UnauthorizedException {
        block11: {
            this.checkRepositoryURL();
            if (this.transactionURL == null) {
                throw new IllegalStateException("Transaction URL has not been set");
            }
            HttpPut method = null;
            try {
                URIBuilder url = new URIBuilder(this.transactionURL);
                url.addParameter("action", Protocol.Action.PREPARE.toString());
                method = this.applyAdditionalHeaders(new HttpPut(url.build()));
                HttpResponse response = this.execute((HttpUriRequest)method);
                try {
                    int code = response.getStatusLine().getStatusCode();
                    if (code == 200) {
                        break block11;
                    }
                    throw new RepositoryException("unable to prepare transaction. HTTP error code " + code);
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            catch (URISyntaxException e) {
                this.logger.error("could not create URL for transaction prepare", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                if (method != null) {
                    method.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commitTransaction() throws RDF4JException, IOException, UnauthorizedException {
        block12: {
            this.checkRepositoryURL();
            if (this.transactionURL == null) {
                throw new IllegalStateException("Transaction URL has not been set");
            }
            HttpPut method = null;
            try {
                URIBuilder url = new URIBuilder(this.transactionURL);
                url.addParameter("action", Protocol.Action.COMMIT.toString());
                method = this.applyAdditionalHeaders(new HttpPut(url.build()));
                HttpResponse response = this.execute((HttpUriRequest)method);
                try {
                    int code = response.getStatusLine().getStatusCode();
                    if (code == 200) {
                        this.transactionURL = null;
                        if (this.ping != null) {
                            this.ping.cancel(false);
                        }
                        break block12;
                    }
                    throw new RepositoryException("unable to commit transaction. HTTP error code " + code);
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            catch (URISyntaxException e) {
                this.logger.error("could not create URL for transaction commit", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                if (method != null) {
                    method.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollbackTransaction() throws RDF4JException, IOException, UnauthorizedException {
        block9: {
            this.checkRepositoryURL();
            if (this.transactionURL == null) {
                throw new IllegalStateException("Transaction URL has not been set");
            }
            String requestURL = this.transactionURL;
            HttpDelete method = this.applyAdditionalHeaders(new HttpDelete(requestURL));
            try {
                HttpResponse response = this.execute((HttpUriRequest)method);
                try {
                    int code = response.getStatusLine().getStatusCode();
                    if (code == 204) {
                        this.transactionURL = null;
                        if (this.ping != null) {
                            this.ping.cancel(false);
                        }
                        break block9;
                    }
                    throw new RepositoryException("unable to rollback transaction. HTTP error code " + code);
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            finally {
                method.reset();
            }
        }
    }

    private synchronized void pingTransaction() {
        if (this.transactionURL == null) {
            return;
        }
        if (this.ping != null) {
            this.ping.cancel(false);
        }
        if (this.pingDelay > 0L) {
            this.ping = this.pingScheduler.schedule(() -> this.executeTransactionPing(), this.pingDelay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeTransactionPing() {
        String transactionURL = this.getTransactionURL();
        if (transactionURL == null) {
            return;
        }
        try {
            URIBuilder url = new URIBuilder(transactionURL);
            url.addParameter("action", Protocol.Action.PING.toString());
            HttpPost method = this.applyAdditionalHeaders(new HttpPost(url.build()));
            String text = EntityUtils.toString((HttpEntity)this.executeOK((HttpUriRequest)method).getEntity());
            long timeout = Long.parseLong(text);
            long nextPingDelay = timeout / 2L;
            RDF4JProtocolSession rDF4JProtocolSession = this;
            synchronized (rDF4JProtocolSession) {
                if (this.pingDelay != nextPingDelay) {
                    this.pingDelay = nextPingDelay;
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to ping transaction", (Object)e.toString());
        }
        this.pingTransaction();
    }

    private String appendAction(String url, Protocol.Action action) {
        return url + "?action=" + action.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void sendTransaction(final Iterable<? extends TransactionOperation> txn) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpPost method = this.applyAdditionalHeaders(new HttpPost(Protocol.getStatementsLocation((String)this.getQueryURL())));
        try {
            method.setEntity((HttpEntity)new AbstractHttpEntity(){

                public long getContentLength() {
                    return -1L;
                }

                public Header getContentType() {
                    return new BasicHeader("Content-Type", "application/x-rdftransaction");
                }

                public boolean isRepeatable() {
                    return true;
                }

                public boolean isStreaming() {
                    return true;
                }

                public InputStream getContent() throws IOException, IllegalStateException {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    this.writeTo(buf);
                    return new ByteArrayInputStream(buf.toByteArray());
                }

                public void writeTo(OutputStream out) throws IOException {
                    TransactionWriter txnWriter = new TransactionWriter();
                    txnWriter.serialize(txn, out);
                }
            });
            try {
                this.executeNoContent((HttpUriRequest)method);
            }
            catch (RepositoryException e) {
                throw e;
            }
            catch (RDF4JException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        finally {
            method.reset();
        }
    }

    public void addData(InputStream contents, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws UnauthorizedException, RDFParseException, RepositoryException, IOException {
        this.upload(contents, baseURI, dataFormat, false, true, Protocol.Action.ADD, contexts);
    }

    public void removeData(InputStream contents, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws UnauthorizedException, RDFParseException, RepositoryException, IOException {
        this.upload(contents, baseURI, dataFormat, false, true, Protocol.Action.DELETE, contexts);
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        this.upload(contents, baseURI, dataFormat, overwrite, preserveNodeIds, Protocol.Action.ADD, contexts);
    }

    protected void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Protocol.Action action, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        InputStreamEntity entity = new InputStreamEntity(contents, -1L, ContentType.parse((String)dataFormat.getDefaultMIMEType()));
        this.upload((HttpEntity)entity, baseURI, overwrite, preserveNodeIds, action, contexts);
    }

    public void upload(Reader contents, String baseURI, RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Resource ... contexts) throws UnauthorizedException, RDFParseException, RepositoryException, IOException {
        this.upload(contents, baseURI, dataFormat, overwrite, preserveNodeIds, Protocol.Action.ADD, contexts);
    }

    @Override
    protected HttpUriRequest getQueryMethod(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        RequestBuilder builder;
        String transactionURL = this.getTransactionURL();
        if (transactionURL != null) {
            builder = RequestBuilder.put((String)transactionURL);
            builder.setHeader("Content-Type", "application/sparql-query; charset=utf-8");
            builder.addParameter("action", Protocol.Action.QUERY.toString());
            for (NameValuePair nameValuePair : this.getQueryMethodParameters(ql, null, baseURI, dataset, includeInferred, maxQueryTime, bindings)) {
                builder.addParameter(nameValuePair);
            }
            builder.setEntity((HttpEntity)new StringEntity(query, UTF8));
            this.pingTransaction();
        } else {
            builder = RequestBuilder.post((String)this.getQueryURL());
            builder.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getQueryMethodParameters(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings), UTF8));
        }
        for (Map.Entry entry : this.getAdditionalHttpHeaders().entrySet()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    @Override
    protected HttpUriRequest getUpdateMethod(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, int maxExecutionTime, Binding ... bindings) {
        RequestBuilder builder;
        String transactionURL = this.getTransactionURL();
        if (transactionURL != null) {
            builder = RequestBuilder.put((String)transactionURL);
            builder.addHeader("Content-Type", "application/sparql-update; charset=utf-8");
            builder.addParameter("action", Protocol.Action.UPDATE.toString());
            for (NameValuePair nameValuePair : this.getUpdateMethodParameters(ql, null, baseURI, dataset, includeInferred, maxExecutionTime, bindings)) {
                builder.addParameter(nameValuePair);
            }
            builder.setEntity((HttpEntity)new StringEntity(update, UTF8));
            this.pingTransaction();
        } else {
            builder = RequestBuilder.post((String)this.getUpdateURL());
            builder.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getUpdateMethodParameters(ql, update, baseURI, dataset, includeInferred, maxExecutionTime, bindings), UTF8));
        }
        for (Map.Entry entry : this.getAdditionalHttpHeaders().entrySet()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    protected void upload(final Reader contents, String baseURI, final RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Protocol.Action action, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        final Charset charset = dataFormat.hasCharset() ? dataFormat.getCharset() : StandardCharsets.UTF_8;
        AbstractHttpEntity entity = new AbstractHttpEntity(){
            private InputStream content;

            public long getContentLength() {
                return -1L;
            }

            public Header getContentType() {
                return new BasicHeader("Content-Type", dataFormat.getDefaultMIMEType() + "; charset=" + charset.name());
            }

            public boolean isRepeatable() {
                return false;
            }

            public boolean isStreaming() {
                return true;
            }

            public synchronized InputStream getContent() throws IOException, IllegalStateException {
                if (this.content == null) {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    this.writeTo(buf);
                    this.content = new ByteArrayInputStream(buf.toByteArray());
                }
                return this.content;
            }

            public void writeTo(OutputStream out) throws IOException {
                try (Reader reader = contents;){
                    OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                    IOUtil.transfer((Reader)contents, (Writer)writer);
                    writer.flush();
                }
            }
        };
        this.upload((HttpEntity)entity, baseURI, overwrite, preserveNodeIds, action, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(HttpEntity reqEntity, String baseURI, boolean overwrite, boolean preserveNodeIds, Protocol.Action action, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
        this.checkRepositoryURL();
        String transactionURL = this.getTransactionURL();
        boolean useTransaction = transactionURL != null;
        try {
            String baseLocation = useTransaction ? transactionURL : Protocol.getStatementsLocation((String)this.getQueryURL());
            URIBuilder url = new URIBuilder(baseLocation);
            for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
                url.addParameter("context", encodedContext);
            }
            if (baseURI != null && baseURI.trim().length() != 0) {
                String encodedBaseURI = Protocol.encodeValue((Value)SimpleValueFactory.getInstance().createIRI(baseURI));
                url.setParameter("baseURI", encodedBaseURI);
            }
            if (preserveNodeIds) {
                url.setParameter("preserveNodeId", "true");
            }
            if (useTransaction) {
                if (action == null) {
                    throw new IllegalArgumentException("action can not be null on transaction operation");
                }
                url.setParameter("action", action.toString());
            }
            HttpEntityEnclosingRequestBase method = null;
            try {
                method = overwrite || useTransaction ? (HttpEntityEnclosingRequestBase)this.applyAdditionalHeaders(new HttpPut(url.build())) : (HttpEntityEnclosingRequestBase)this.applyAdditionalHeaders(new HttpPost(url.build()));
                method.setEntity(reqEntity);
                try {
                    this.executeNoContent((HttpUriRequest)method);
                }
                catch (RepositoryException | RDFParseException e) {
                    throw e;
                }
                catch (RDF4JException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            finally {
                if (method != null) {
                    method.reset();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        this.pingTransaction();
    }

    @Override
    public void setUsernameAndPassword(String username, String password) {
        this.checkServerURL();
        this.setUsernameAndPasswordForUrl(username, password, this.getServerURL());
    }

    @Override
    protected List<NameValuePair> getQueryMethodParameters(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        Objects.requireNonNull(ql, "QueryLanguage may not be null");
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("queryLn", ql.getName()));
        queryParams.add((NameValuePair)new BasicNameValuePair("query", query));
        if (baseURI != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("baseURI", baseURI));
        }
        queryParams.add((NameValuePair)new BasicNameValuePair("infer", Boolean.toString(includeInferred)));
        if (maxQueryTime > 0) {
            queryParams.add((NameValuePair)new BasicNameValuePair("timeout", Integer.toString(maxQueryTime)));
        }
        if (dataset != null) {
            for (IRI defaultGraphURI : dataset.getDefaultGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("default-graph-uri", String.valueOf(defaultGraphURI)));
            }
            for (IRI namedGraphURI : dataset.getNamedGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("named-graph-uri", String.valueOf(namedGraphURI)));
            }
        }
        for (int i = 0; i < bindings.length; ++i) {
            String paramName = "$" + bindings[i].getName();
            String paramValue = Protocol.encodeValue((Value)bindings[i].getValue());
            queryParams.add((NameValuePair)new BasicNameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    @Override
    protected List<NameValuePair> getUpdateMethodParameters(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        Objects.requireNonNull(ql, "QueryLanguage may not be null");
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("queryLn", ql.getName()));
        if (update != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("update", update));
        }
        if (baseURI != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("baseURI", baseURI));
        }
        queryParams.add((NameValuePair)new BasicNameValuePair("infer", Boolean.toString(includeInferred)));
        if (dataset != null) {
            for (IRI graphURI : dataset.getDefaultRemoveGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("remove-graph-uri", String.valueOf(graphURI)));
            }
            if (dataset.getDefaultInsertGraph() != null) {
                queryParams.add((NameValuePair)new BasicNameValuePair("insert-graph-uri", String.valueOf(dataset.getDefaultInsertGraph())));
            }
            for (IRI defaultGraphURI : dataset.getDefaultGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("using-graph-uri", String.valueOf(defaultGraphURI)));
            }
            for (IRI namedGraphURI : dataset.getNamedGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("using-named-graph-uri", String.valueOf(namedGraphURI)));
            }
        }
        if (maxQueryTime > 0) {
            queryParams.add((NameValuePair)new BasicNameValuePair("timeout", Integer.toString(maxQueryTime)));
        }
        for (int i = 0; i < bindings.length; ++i) {
            String paramName = "$" + bindings[i].getName();
            String paramValue = Protocol.encodeValue((Value)bindings[i].getValue());
            queryParams.add((NameValuePair)new BasicNameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    private <T extends HttpUriRequest> T applyAdditionalHeaders(T method) {
        for (Map.Entry<String, String> additionalHeader : this.getAdditionalHttpHeaders().entrySet()) {
            method.addHeader(additionalHeader.getKey(), additionalHeader.getValue());
        }
        return method;
    }
}

