/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSourceHelper;

public class BackwardChainingShapeSource
implements ShapeSource {
    private final SailConnection connection;
    private final Resource[] context;

    public BackwardChainingShapeSource(SailConnection connection) {
        this(connection, null);
    }

    private BackwardChainingShapeSource(SailConnection connection, Resource[] context) {
        this.connection = connection;
        this.context = context;
        assert (connection.isActive());
    }

    @Override
    public BackwardChainingShapeSource withContext(Resource[] context) {
        return new BackwardChainingShapeSource(this.connection, context);
    }

    @Override
    public Resource[] getActiveContexts() {
        return this.context;
    }

    @Override
    public Stream<ShapeSource.ShapesGraph> getAllShapeContexts() {
        assert (this.context != null);
        try (Stream stream = this.connection.getStatements(null, SHACL.SHAPES_GRAPH, null, false, this.context).stream();){
            Stream<ShapeSource.ShapesGraph> stream2 = stream.collect(Collectors.groupingBy(Statement::getSubject)).entrySet().stream().map(entry -> new ShapeSource.ShapesGraph((Resource)entry.getKey(), (List)entry.getValue()));
            return stream2;
        }
    }

    @Override
    public Stream<Resource> getTargetableShape() {
        assert (this.context != null);
        Stream<Resource> inferred = this.connection.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, true, this.context).stream().map(Statement::getSubject).filter(this::isNodeShapeOrPropertyShape);
        return Stream.of(this.getSubjects(ShapeSource.Predicates.TARGET_NODE), this.getSubjects(ShapeSource.Predicates.TARGET_CLASS), this.getSubjects(ShapeSource.Predicates.TARGET_SUBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_OBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_PROP), this.getSubjects(ShapeSource.Predicates.RSX_targetShape), inferred).reduce(Stream::concat).get().distinct();
    }

    private boolean isNodeShapeOrPropertyShape(Resource id) {
        return this.connection.hasStatement(id, RDF.TYPE, (Value)SHACL.NODE_SHAPE, true, this.context) || this.connection.hasStatement(id, RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE, true, this.context);
    }

    @Override
    public Stream<Resource> getSubjects(ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, this.context).stream().map(Statement::getSubject).distinct();
    }

    @Override
    public Stream<Value> getObjects(Resource subject, ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(subject, predicate.getIRI(), null, true, this.context).stream().map(Statement::getObject).distinct();
    }

    @Override
    public Stream<Statement> getAllStatements(Resource id) {
        assert (this.context != null);
        Stream<Statement> backwardsChained = DASH_CONSTANTS.stream();
        if (this.connection.hasStatement(id, SHACL.PATH, null, true, this.context)) {
            backwardsChained = Stream.concat(backwardsChained, Stream.of(Statements.statement((Resource)id, (IRI)RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE, null)));
        }
        if (this.connection.hasStatement(id, RDF.TYPE, (Value)RDFS.CLASS, true, this.context) && this.isNodeShapeOrPropertyShape(id)) {
            backwardsChained = Stream.concat(backwardsChained, Stream.of(Statements.statement((Resource)id, (IRI)SHACL.TARGET_CLASS, (Value)id, null)));
        }
        return Stream.concat(this.connection.getStatements(id, null, null, true, this.context).stream().map(s -> s), backwardsChained);
    }

    @Override
    public Value getRdfFirst(Resource subject) {
        return ShapeSourceHelper.getFirst(this.connection, subject, this.context);
    }

    @Override
    public Resource getRdfRest(Resource subject) {
        return ShapeSourceHelper.getRdfRest(this.connection, subject, this.context);
    }

    @Override
    public boolean isType(Resource subject, IRI type) {
        assert (this.context != null);
        return DASH_CONSTANTS.contains(subject, RDF.TYPE, (Value)type, new Resource[0]) || this.connection.hasStatement(subject, RDF.TYPE, (Value)type, true, this.context);
    }

    @Override
    public void close() {
    }
}

