/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetChainRetriever
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(TargetChainRetriever.class);
    private final ConnectionsGroup connectionsGroup;
    private final List<StatementMatcher> statementMatchers;
    private final List<StatementMatcher> removedStatementMatchers;
    private final String query;
    private final QueryParserFactory queryParserFactory;
    private final ConstraintComponent.Scope scope;
    private final Resource[] dataGraph;
    private final Dataset dataset;
    private StackTraceElement[] stackTrace;
    private ValidationExecutionLogger validationExecutionLogger;

    public TargetChainRetriever(ConnectionsGroup connectionsGroup, Resource[] dataGraph, List<StatementMatcher> statementMatchers, List<StatementMatcher> removedStatementMatchers, String query, List<StatementMatcher.Variable> vars, ConstraintComponent.Scope scope) {
        this.connectionsGroup = connectionsGroup;
        this.dataGraph = dataGraph;
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(this.dataGraph);
        this.statementMatchers = StatementMatcher.reduce(statementMatchers);
        this.scope = scope;
        String sparqlProjection = vars.stream().map(s -> "?" + s.getName()).reduce((a, b) -> a + " " + b).orElseThrow(IllegalStateException::new);
        this.query = "select " + sparqlProjection + " where {\n" + StatementMatcher.StableRandomVariableProvider.normalize(query) + "\n}";
        this.queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
        this.removedStatementMatchers = removedStatementMatchers != null ? StatementMatcher.reduce(removedStatementMatchers) : Collections.emptyList();
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final Iterator<StatementMatcher> statementPatternIterator;
            final Iterator<StatementMatcher> removedStatementIterator;
            StatementMatcher currentStatementMatcher;
            CloseableIteration<? extends Statement, SailException> statements;
            ValidationTuple next;
            CloseableIteration<? extends BindingSet, QueryEvaluationException> results;
            ParsedQuery parsedQuery;
            MapBindingSet previousBindings;
            {
                this.statementPatternIterator = TargetChainRetriever.this.statementMatchers.iterator();
                this.removedStatementIterator = TargetChainRetriever.this.removedStatementMatchers.iterator();
            }

            public void calculateNextStatementMatcher() {
                if (this.statements != null && this.statements.hasNext()) {
                    return;
                }
                if (!this.statementPatternIterator.hasNext() && !this.removedStatementIterator.hasNext()) {
                    if (this.statements != null) {
                        this.statements.close();
                        this.statements = null;
                    }
                    return;
                }
                do {
                    SailConnection connection;
                    if (this.statements != null) {
                        this.statements.close();
                        this.statements = null;
                    }
                    if (!this.statementPatternIterator.hasNext() && !this.removedStatementIterator.hasNext()) break;
                    if (this.statementPatternIterator.hasNext()) {
                        this.currentStatementMatcher = this.statementPatternIterator.next();
                        connection = TargetChainRetriever.this.connectionsGroup.getAddedStatements();
                    } else {
                        if (!TargetChainRetriever.this.connectionsGroup.getStats().hasRemoved()) break;
                        this.currentStatementMatcher = this.removedStatementIterator.next();
                        connection = TargetChainRetriever.this.connectionsGroup.getRemovedStatements();
                    }
                    this.statements = connection.getStatements(this.currentStatementMatcher.getSubjectValue(), this.currentStatementMatcher.getPredicateValue(), this.currentStatementMatcher.getObjectValue(), false, TargetChainRetriever.this.dataGraph);
                } while (!this.statements.hasNext());
                this.previousBindings = null;
            }

            private void calculateNextResult() {
                if (this.next != null) {
                    return;
                }
                while (this.results == null || !this.results.hasNext()) {
                    try {
                        if (this.results != null) {
                            this.results.close();
                            this.results = null;
                        }
                        while (this.statements == null || !this.statements.hasNext()) {
                            this.calculateNextStatementMatcher();
                            if (this.statements != null) continue;
                            return;
                        }
                        if (this.parsedQuery == null) {
                            this.parsedQuery = TargetChainRetriever.this.queryParserFactory.getParser().parseQuery(TargetChainRetriever.this.query, null);
                        }
                        Statement next = (Statement)this.statements.next();
                        MapBindingSet bindings = new MapBindingSet();
                        if (this.currentStatementMatcher.getSubjectValue() == null && !this.currentStatementMatcher.subjectIsWildcard()) {
                            bindings.addBinding(this.currentStatementMatcher.getSubjectName(), (Value)next.getSubject());
                        }
                        if (this.currentStatementMatcher.getPredicateValue() == null && !this.currentStatementMatcher.predicateIsWildcard()) {
                            bindings.addBinding(this.currentStatementMatcher.getPredicateName(), (Value)next.getPredicate());
                        }
                        if (this.currentStatementMatcher.getObjectValue() == null && !this.currentStatementMatcher.objectIsWildcard()) {
                            bindings.addBinding(this.currentStatementMatcher.getObjectName(), next.getObject());
                        }
                        if (TargetChainRetriever.bindingsEquivalent(this.currentStatementMatcher, bindings, this.previousBindings)) continue;
                        this.previousBindings = bindings;
                        this.results = TargetChainRetriever.this.connectionsGroup.getBaseConnection().evaluate(this.parsedQuery.getTupleExpr(), TargetChainRetriever.this.dataset, (BindingSet)bindings, true);
                    }
                    catch (MalformedQueryException e) {
                        logger.error("Malformed query: \n{}", (Object)TargetChainRetriever.this.query);
                        throw e;
                    }
                }
                if (this.results.hasNext()) {
                    BindingSet nextBinding = (BindingSet)this.results.next();
                    if (nextBinding.size() == 1) {
                        Iterator iterator = nextBinding.iterator();
                        this.next = iterator.hasNext() ? new ValidationTuple(((Binding)iterator.next()).getValue(), TargetChainRetriever.this.scope, false, TargetChainRetriever.this.dataGraph) : new ValidationTuple((Value)null, TargetChainRetriever.this.scope, false, TargetChainRetriever.this.dataGraph);
                    } else {
                        Value[] values = (Value[])StreamSupport.stream(nextBinding.spliterator(), false).sorted(Comparator.comparing(Binding::getName)).map(Binding::getValue).toArray(Value[]::new);
                        this.next = new ValidationTuple(values, TargetChainRetriever.this.scope, false, TargetChainRetriever.this.dataGraph);
                    }
                }
            }

            @Override
            public void localClose() throws SailException {
                try {
                    if (this.statements != null) {
                        this.statements.close();
                    }
                }
                finally {
                    if (this.results != null) {
                        this.results.close();
                    }
                }
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNextResult();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNextResult();
                return this.next != null;
            }
        };
    }

    private static boolean bindingsEquivalent(StatementMatcher currentStatementMatcher, MapBindingSet bindings, MapBindingSet previousBindings) {
        if (currentStatementMatcher == null || bindings == null || previousBindings == null) {
            return false;
        }
        boolean equivalent = true;
        if (equivalent && currentStatementMatcher.getSubjectValue() == null && !currentStatementMatcher.subjectIsWildcard()) {
            equivalent = Objects.equals(bindings.getBinding(currentStatementMatcher.getSubjectName()), previousBindings.getBinding(currentStatementMatcher.getSubjectName()));
        }
        if (equivalent && currentStatementMatcher.getPredicateValue() == null && !currentStatementMatcher.predicateIsWildcard()) {
            equivalent = Objects.equals(bindings.getBinding(currentStatementMatcher.getPredicateName()), previousBindings.getBinding(currentStatementMatcher.getPredicateName()));
        }
        if (equivalent && currentStatementMatcher.getObjectValue() == null && !currentStatementMatcher.objectIsWildcard()) {
            equivalent = Objects.equals(bindings.getBinding(currentStatementMatcher.getObjectName()), previousBindings.getBinding(currentStatementMatcher.getObjectName()));
        }
        return equivalent;
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetChainRetriever that = (TargetChainRetriever)o;
        return this.statementMatchers.equals(that.statementMatchers) && this.removedStatementMatchers.equals(that.removedStatementMatchers) && this.query.equals(that.query) && Objects.equals(this.dataset, that.dataset) && this.scope == that.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statementMatchers, this.removedStatementMatchers, this.query, this.scope, this.dataset});
    }

    public String toString() {
        return "TargetChainRetriever{statementPatterns=" + this.statementMatchers + ", removedStatementMatchers=" + this.removedStatementMatchers + ", query='" + this.query.replace("\n", "\t") + "', scope=" + this.scope + "}";
    }
}

