/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.write;

import org.eclipse.rdf4j.federated.write.WriteStrategy;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class RepositoryWriteStrategy
implements WriteStrategy {
    private final Repository writeRepository;
    private RepositoryConnection connection = null;

    public RepositoryWriteStrategy(Repository writeRepository) {
        this.writeRepository = writeRepository;
    }

    @Override
    public void close() throws RepositoryException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public void begin() throws RepositoryException {
        this.createConnection();
        this.connection.begin();
    }

    @Override
    public void commit() throws RepositoryException {
        this.createConnection();
        this.connection.commit();
    }

    @Override
    public void rollback() throws RepositoryException {
        this.createConnection();
        this.connection.rollback();
    }

    @Override
    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        this.createConnection();
        this.connection.add(subj, pred, obj, contexts);
    }

    @Override
    public void removeStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        this.createConnection();
        this.connection.remove(subj, pred, obj, contexts);
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        this.createConnection();
        this.connection.clear(contexts);
    }

    private void createConnection() throws RepositoryException {
        if (this.connection == null || !this.connection.isOpen()) {
            this.connection = this.writeRepository.getConnection();
        }
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        this.createConnection();
        this.connection.clearNamespaces();
    }
}

