/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import java.util.Optional;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.PrecompiledQueryNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.BindingAssigner;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;

class SailSourceEvaluationStrategyFactory
implements EvaluationStrategyFactory {
    private final EvaluationStrategyFactory delegate;

    public SailSourceEvaluationStrategyFactory(EvaluationStrategyFactory delegate) {
        this.delegate = delegate;
    }

    public void setQuerySolutionCacheThreshold(long threshold) {
        this.delegate.setQuerySolutionCacheThreshold(threshold);
    }

    public long getQuerySolutionCacheThreshold() {
        return this.delegate.getQuerySolutionCacheThreshold();
    }

    public void setOptimizerPipeline(QueryOptimizerPipeline pipeline) {
        this.delegate.setOptimizerPipeline(pipeline);
    }

    public Optional<QueryOptimizerPipeline> getOptimizerPipeline() {
        return this.delegate.getOptimizerPipeline();
    }

    public EvaluationStrategy createEvaluationStrategy(Dataset dataset, TripleSource tripleSource, EvaluationStatistics evaluationStatistics) {
        EvaluationStrategy delegateStrategy = this.delegate.createEvaluationStrategy(dataset, tripleSource, evaluationStatistics);
        return new SailSourceEvaluationStrategy(delegateStrategy, dataset);
    }

    private static class SailSourceEvaluationStrategy
    implements EvaluationStrategy {
        private final EvaluationStrategy delegate;
        private final Dataset dataset;

        public SailSourceEvaluationStrategy(EvaluationStrategy delegate, Dataset dataset) {
            this.delegate = delegate;
            this.dataset = dataset;
        }

        public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
            return this.delegate.getService(serviceUrl);
        }

        public void setOptimizerPipeline(QueryOptimizerPipeline pipeline) {
            this.delegate.setOptimizerPipeline(pipeline);
        }

        public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
            if (expr instanceof PrecompiledQueryNode) {
                return this.optimizePreparedQuery((PrecompiledQueryNode)expr, bindings);
            }
            return this.delegate.optimize(expr, evaluationStatistics, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service expr, String serviceUri, CloseableIteration<BindingSet, QueryEvaluationException> bindings) throws QueryEvaluationException {
            return this.delegate.evaluate(expr, serviceUri, bindings);
        }

        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
            return this.delegate.evaluate(expr, bindings);
        }

        public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.delegate.evaluate(expr, bindings);
        }

        public boolean isTrue(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.delegate.isTrue(expr, bindings);
        }

        protected TupleExpr optimizePreparedQuery(PrecompiledQueryNode preparedQuery, BindingSet bindings) {
            TupleExpr actualQuery = preparedQuery.getQuery();
            if (bindings != null) {
                new BindingAssigner().optimize(actualQuery, this.dataset, bindings);
            }
            return actualQuery;
        }
    }
}

