/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc.config;

import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.inferencer.fc.CustomGraphQueryInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.config.CustomGraphQueryInferencerConfig;

public class CustomGraphQueryInferencerFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:CustomGraphQueryInferencer";

    public String getSailType() {
        return SAIL_TYPE;
    }

    public SailImplConfig getConfig() {
        return new CustomGraphQueryInferencerConfig();
    }

    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        CustomGraphQueryInferencer sail = new CustomGraphQueryInferencer();
        if (config instanceof CustomGraphQueryInferencerConfig) {
            CustomGraphQueryInferencerConfig customConfig = (CustomGraphQueryInferencerConfig)config;
            try {
                sail.setFields(customConfig.getQueryLanguage(), customConfig.getRuleQuery(), customConfig.getMatcherQuery());
            }
            catch (RDF4JException e) {
                throw new SailConfigException("Problem occured parsing rule or matcher query text.", (Throwable)e);
            }
        }
        return sail;
    }
}

