/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrEnds
implements Function {
    @Override
    public String getURI() {
        return FN.ENDS_WITH.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("STRENDS requires 2 arguments, got " + args.length);
        }
        Value leftVal = args[0];
        Value rightVal = args[1];
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            Literal leftLit = (Literal)leftVal;
            Literal rightLit = (Literal)rightVal;
            if (QueryEvaluationUtil.compatibleArguments(leftLit, rightLit)) {
                String leftLexVal = leftLit.getLabel();
                String rightLexVal = rightLit.getLabel();
                return BooleanLiteral.valueOf((boolean)leftLexVal.endsWith(rightLexVal));
            }
            throw new ValueExprEvaluationException("incompatible operands for STRENDS function");
        }
        throw new ValueExprEvaluationException("STRENDS function expects literal operands");
    }
}

