/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.AST.InversePath;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.SimplePath;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;

@Deprecated
public class ValidationResult {
    private final Resource id = SimpleValueFactory.getInstance().createBNode();
    private final SourceConstraintComponent sourceConstraintComponent;
    private final PropertyShape sourceShape;
    private Path path;
    private ValidationResult detail;
    private final Value focusNode;
    private final Optional<Value> value;

    public ValidationResult(PropertyShape sourceShape, Value focusNode, Value value) {
        this.sourceShape = sourceShape;
        this.focusNode = focusNode;
        this.sourceConstraintComponent = sourceShape.getSourceConstraintComponent();
        if (sourceShape instanceof PathPropertyShape) {
            this.path = ((PathPropertyShape)sourceShape).getPath();
        }
        this.value = this.sourceConstraintComponent.producesValidationResultValue() && this.sourceConstraintComponent.getConstraintType() != SourceConstraintComponent.ConstraintType.Logical ? Optional.of(value) : Optional.empty();
    }

    public void setDetail(ValidationResult detail) {
        this.detail = detail;
    }

    public ValidationResult getDetail() {
        return this.detail;
    }

    public List<ValidationResult> getDetails() {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        ValidationResult temp = this.detail;
        while (temp != null) {
            validationResults.add(temp);
            temp = temp.detail;
        }
        return validationResults;
    }

    public Model asModel(Model model) {
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.VALIDATION_RESULT, new Resource[0]);
        model.add(this.getId(), SHACL.FOCUS_NODE, this.getFocusNode(), new Resource[0]);
        model.add(this.getId(), SHACL.SOURCE_CONSTRAINT_COMPONENT, (Value)this.getSourceConstraintComponent().getIri(), new Resource[0]);
        model.add(this.getId(), SHACL.SOURCE_SHAPE, (Value)this.getSourceShapeResource(), new Resource[0]);
        if (this.getPath() != null) {
            if (this.getPath() instanceof SimplePath) {
                model.add(this.getId(), SHACL.RESULT_PATH, (Value)((SimplePath)this.getPath()).getPath(), new Resource[0]);
            } else if (this.getPath() instanceof InversePath) {
                model.add(this.getId(), SHACL.RESULT_PATH, (Value)this.getPath().getId(), new Resource[0]);
                model.add(this.getPath().getId(), SHACL.INVERSE_PATH, (Value)((InversePath)this.getPath()).getPath(), new Resource[0]);
            }
        }
        this.value.ifPresent(v -> model.add(this.getId(), SHACL.VALUE, v, new Resource[0]));
        if (this.detail != null) {
            model.add(this.getId(), SHACL.DETAIL, (Value)this.detail.getId(), new Resource[0]);
            this.detail.asModel(model);
        }
        return model;
    }

    private Path getPath() {
        return this.path;
    }

    public Resource getSourceShapeResource() {
        return this.sourceShape.getId();
    }

    private Value getFocusNode() {
        return this.focusNode;
    }

    public Resource getId() {
        return this.id;
    }

    public SourceConstraintComponent getSourceConstraintComponent() {
        return this.sourceConstraintComponent;
    }

    public String toString() {
        return "ValidationResult{sourceConstraintComponent=" + (Object)((Object)this.sourceConstraintComponent) + ", sourceShape=" + this.sourceShape + ", path=" + this.path + ", detail=" + this.detail + ", focusNode=" + this.focusNode + '}';
    }

    public Optional<Value> getValue() {
        return this.value;
    }
}

