/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.tsv;

import com.opencsv.CSVReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.text.SPARQLResultsXSVMappingStrategy;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;

public class SPARQLResultsTSVMappingStrategy
extends SPARQLResultsXSVMappingStrategy {
    public SPARQLResultsTSVMappingStrategy(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public void captureHeader(CSVReader reader) throws IOException {
        this.bindingNames = Stream.of(reader.readNext()).map(s -> StringUtils.removeStart((String)s, (String)"?")).collect(Collectors.toList());
    }

    public BindingSet populateNewBean(String[] line) {
        ArrayList<Value> values = new ArrayList<Value>(line.length);
        for (String valueString : line) {
            values.add(this.parseValue(valueString));
        }
        return new ListBindingSet(this.bindingNames, values.toArray(new Value[values.size()]));
    }

    protected Value parseValue(String valueString) {
        Object v = null;
        if (valueString.startsWith("<<")) {
            v = NTriplesUtil.parseTriple((String)valueString, (ValueFactory)this.valueFactory);
        } else if (valueString.startsWith("_:")) {
            v = this.valueFactory.createBNode(valueString.substring(2));
        } else if (valueString.startsWith("<") && valueString.endsWith(">")) {
            try {
                v = this.valueFactory.createIRI(valueString.substring(1, valueString.length() - 1));
            }
            catch (IllegalArgumentException e) {
                v = this.valueFactory.createLiteral(valueString);
            }
        } else if (valueString.startsWith("\"")) {
            v = this.parseLiteral(valueString);
        } else if (!"".equals(valueString)) {
            v = numberPattern.matcher(valueString).matches() ? this.parseNumberPatternMatch(valueString) : this.valueFactory.createLiteral(valueString);
        }
        return v;
    }

    protected Literal parseLiteral(String literal) throws IllegalArgumentException {
        int endLabelIdx;
        if (literal.startsWith("\"") && (endLabelIdx = this.findEndOfLabel(literal)) != -1) {
            int startLangIdx = literal.indexOf(64, endLabelIdx);
            int startDtIdx = literal.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = literal.substring(1, endLabelIdx);
            label = SPARQLResultsTSVMappingStrategy.decodeString(label);
            if (startLangIdx != -1) {
                String language = literal.substring(startLangIdx + 1);
                return this.valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = literal.substring(startDtIdx + 2);
                datatype = datatype.substring(1, datatype.length() - 1);
                IRI dtURI = this.valueFactory.createIRI(datatype);
                return this.valueFactory.createLiteral(label, dtURI);
            }
            return this.valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal literal: " + literal);
    }

    private int findEndOfLabel(String literal) {
        return literal.lastIndexOf(34);
    }

    protected static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '>') {
                sb.append('>');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }
}

