/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class LanguageInFilter
extends FilterPlanNode {
    private final Set<String> languageIn;

    public LanguageInFilter(PlanNode parent, Set<String> languageIn) {
        super(parent);
        this.languageIn = languageIn;
    }

    @Override
    boolean checkTuple(Tuple t) {
        if (!(t.getLine().get(1) instanceof Literal)) {
            return false;
        }
        Optional<String> language = ((Literal)t.getLine().get(1)).getLanguage();
        return language.filter(this.languageIn::contains).isPresent();
    }

    @Override
    public String toString() {
        return "LanguageInFilter{languageIn=" + Arrays.toString(this.languageIn.toArray()) + '}';
    }
}

