/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.AbstractSimplePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.NodeKindFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeKindPropertyShape
extends AbstractSimplePropertyShape {
    private final NodeKind nodeKind;
    private static final Logger logger = LoggerFactory.getLogger(NodeKindPropertyShape.class);

    NodeKindPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource nodeKind) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.nodeKind = NodeKind.from(nodeKind);
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        PlanNode invalidValues = NodeKindPropertyShape.getGenericSingleObjectPlan(connectionsGroup, this.nodeShape, parent -> new NodeKindFilter(parent, this.nodeKind), this, overrideTargetNode, negateThisPlan);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, connectionsGroup);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.NodeKindConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeKindPropertyShape that = (NodeKindPropertyShape)o;
        return this.nodeKind == that.nodeKind;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.nodeKind});
    }

    public String toString() {
        return "NodeKindPropertyShape{nodeKind=" + (Object)((Object)this.nodeKind) + ", path=" + this.getPath() + ", id=" + this.id + '}';
    }

    public static enum NodeKind {
        BlankNode(SHACL.BLANK_NODE),
        IRI(SHACL.IRI),
        Literal(SHACL.LITERAL),
        BlankNodeOrIRI(SHACL.BLANK_NODE_OR_IRI),
        BlankNodeOrLiteral(SHACL.BLANK_NODE_OR_LITERAL),
        IRIOrLiteral(SHACL.IRI_OR_LITERAL);

        IRI iri;

        private NodeKind(IRI iri) {
            this.iri = iri;
        }

        public static NodeKind from(Resource resource) {
            for (NodeKind value : NodeKind.values()) {
                if (!value.iri.equals(resource)) continue;
                return value;
            }
            throw new IllegalStateException("Unknown nodeKind: " + resource);
        }
    }
}

