/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectTypeHierarchyInferencer
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DirectTypeHierarchyInferencer.class);
    private static final ParsedGraphQuery DIRECT_SUBCLASSOF_MATCHER;
    private static final ParsedGraphQuery DIRECT_SUBCLASSOF_QUERY;
    private static final ParsedGraphQuery DIRECT_SUBPROPERTYOF_MATCHER;
    private static final ParsedGraphQuery DIRECT_SUBPROPERTYOF_QUERY;
    private static final ParsedGraphQuery DIRECT_TYPE_MATCHER;
    private static final ParsedGraphQuery DIRECT_TYPE_QUERY;

    public DirectTypeHierarchyInferencer() {
    }

    public DirectTypeHierarchyInferencer(NotifyingSail baseSail) {
        super(baseSail);
    }

    @Override
    public InferencerConnection getConnection() throws SailException {
        try {
            InferencerConnection con = (InferencerConnection)super.getConnection();
            return new DirectTypeHierarchyInferencerConnection(con);
        }
        catch (ClassCastException e) {
            throw new SailException(e.getMessage(), e);
        }
    }

    @Override
    public void initialize() throws SailException {
        super.initialize();
        try (InferencerConnection con = this.getConnection();){
            con.begin();
            con.flushUpdates();
            con.commit();
        }
    }

    static {
        try {
            DIRECT_SUBCLASSOF_MATCHER = QueryParserUtil.parseGraphQuery(QueryLanguage.SERQL, "CONSTRUCT * FROM {X} sesame:directSubClassOf {Y} ", null);
            DIRECT_SUBPROPERTYOF_MATCHER = QueryParserUtil.parseGraphQuery(QueryLanguage.SERQL, "CONSTRUCT * FROM {X} sesame:directType {Y}", null);
            DIRECT_TYPE_MATCHER = QueryParserUtil.parseGraphQuery(QueryLanguage.SERQL, "CONSTRUCT * FROM {X} sesame:directSubPropertyOf {Y}", null);
            DIRECT_SUBCLASSOF_QUERY = QueryParserUtil.parseGraphQuery(QueryLanguage.SERQL, "CONSTRUCT {X} sesame:directSubClassOf {Y} FROM {X} rdfs:subClassOf {Y} WHERE X != Y AND NOT EXISTS (SELECT Z FROM {X} rdfs:subClassOf {Z} rdfs:subClassOf {Y} WHERE X != Z AND Z != Y)", null);
            DIRECT_SUBPROPERTYOF_QUERY = QueryParserUtil.parseGraphQuery(QueryLanguage.SERQL, "CONSTRUCT {X} sesame:directSubPropertyOf {Y} FROM {X} rdfs:subPropertyOf {Y} WHERE X != Y AND NOT EXISTS (SELECT Z FROM {X} rdfs:subPropertyOf {Z} rdfs:subPropertyOf {Y} WHERE X != Z AND Z != Y)", null);
            DIRECT_TYPE_QUERY = QueryParserUtil.parseGraphQuery(QueryLanguage.SERQL, "CONSTRUCT {X} sesame:directType {Y} FROM {X} rdf:type {Y} WHERE NOT EXISTS (SELECT Z FROM {X} rdf:type {Z} rdfs:subClassOf {Y} WHERE Z != Y)", null);
        }
        catch (MalformedQueryException e) {
            throw new RuntimeException(e);
        }
    }

    private class DirectTypeHierarchyInferencerConnection
    extends InferencerConnectionWrapper
    implements SailConnectionListener {
        private boolean updateNeeded;

        public DirectTypeHierarchyInferencerConnection(InferencerConnection con) {
            super(con);
            this.updateNeeded = false;
            con.addConnectionListener(this);
        }

        @Override
        public void statementAdded(Statement st) {
            this.checkUpdatedStatement(st);
        }

        @Override
        public void statementRemoved(Statement st) {
            this.checkUpdatedStatement(st);
        }

        private void checkUpdatedStatement(Statement st) {
            IRI pred = st.getPredicate();
            if (pred.equals(RDF.TYPE) || pred.equals(RDFS.SUBCLASSOF) || pred.equals(RDFS.SUBPROPERTYOF)) {
                this.updateNeeded = true;
            }
        }

        @Override
        public void rollback() throws SailException {
            super.rollback();
            this.updateNeeded = false;
        }

        @Override
        public void flushUpdates() throws SailException {
            super.flushUpdates();
            while (this.updateNeeded) {
                try {
                    HashSet<Statement> oldStatements = new HashSet<Statement>(256);
                    HashSet<Statement> newStatements = new HashSet<Statement>(256);
                    this.evaluateIntoStatements(DIRECT_SUBCLASSOF_MATCHER, oldStatements);
                    this.evaluateIntoStatements(DIRECT_SUBPROPERTYOF_MATCHER, oldStatements);
                    this.evaluateIntoStatements(DIRECT_TYPE_MATCHER, oldStatements);
                    this.evaluateIntoStatements(DIRECT_SUBCLASSOF_QUERY, newStatements);
                    this.evaluateIntoStatements(DIRECT_SUBPROPERTYOF_QUERY, newStatements);
                    this.evaluateIntoStatements(DIRECT_TYPE_QUERY, newStatements);
                    logger.debug("existing virtual properties: {}", (Object)oldStatements.size());
                    logger.debug("new virtual properties: {}", (Object)newStatements.size());
                    HashSet<Statement> unchangedStatements = new HashSet<Statement>(oldStatements);
                    unchangedStatements.retainAll(newStatements);
                    oldStatements.removeAll(unchangedStatements);
                    newStatements.removeAll(unchangedStatements);
                    logger.debug("virtual properties to remove: {}", (Object)oldStatements.size());
                    logger.debug("virtual properties to add: {}", (Object)newStatements.size());
                    Resource[] contexts = new Resource[]{null};
                    for (Statement st : oldStatements) {
                        this.removeInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    for (Statement st : newStatements) {
                        this.addInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    this.updateNeeded = false;
                }
                catch (RDFHandlerException e) {
                    Throwable t = e.getCause();
                    if (t instanceof SailException) {
                        throw (SailException)t;
                    }
                    throw new SailException(t);
                }
                catch (QueryEvaluationException e) {
                    throw new SailException(e);
                }
                super.flushUpdates();
            }
        }

        private void evaluateIntoStatements(ParsedGraphQuery query, Collection<Statement> statements) throws SailException, RDFHandlerException, QueryEvaluationException {
            try (CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter = this.getWrappedConnection().evaluate(query.getTupleExpr(), null, EmptyBindingSet.getInstance(), true);){
                ValueFactory vf = DirectTypeHierarchyInferencer.this.getValueFactory();
                while (bindingsIter.hasNext()) {
                    BindingSet bindings = (BindingSet)bindingsIter.next();
                    Value subj = bindings.getValue("subject");
                    Value pred = bindings.getValue("predicate");
                    Value obj = bindings.getValue("object");
                    if (!(subj instanceof Resource) || !(pred instanceof IRI) || obj == null) continue;
                    statements.add(vf.createStatement((Resource)subj, (IRI)pred, obj));
                }
            }
        }
    }
}

