/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.trig;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;

public class TriGWriter
extends TurtleWriter {
    private boolean inActiveContext;
    private Resource currentContext;

    public TriGWriter(OutputStream out) {
        super(out);
    }

    public TriGWriter(OutputStream out, ParsedIRI baseIRI) {
        super(out, baseIRI);
    }

    public TriGWriter(Writer writer) {
        super(writer);
    }

    public TriGWriter(Writer writer, ParsedIRI baseIRI) {
        super(writer, baseIRI);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIG;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.inActiveContext = false;
        this.currentContext = null;
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        super.endRDF();
        try {
            this.closeActiveContext();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    protected void writeStatement(Resource subj, IRI pred, Value obj, Resource context, boolean canShortenSubject, boolean canShortenObject) throws IOException {
        try {
            if (this.inActiveContext && !TriGWriter.contextsEquals(context, this.currentContext)) {
                this.closePreviousStatement();
                this.closeActiveContext();
            }
            if (!this.inActiveContext) {
                this.writer.writeEOL();
                if (context != null) {
                    boolean canShortenContext = false;
                    if (context instanceof BNode && this.bufferedStatements != null && !this.bufferedStatements.contains(context, null, null, new Resource[0]) && !this.bufferedStatements.contains(null, null, (Value)context, new Resource[0])) {
                        canShortenContext = true;
                    }
                    this.writeResource(context, canShortenContext);
                    this.writer.write(" ");
                }
                this.writer.write("{");
                this.writer.increaseIndentation();
                this.currentContext = context;
                this.inActiveContext = true;
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
        super.writeStatement(subj, pred, obj, context, canShortenSubject, canShortenObject);
    }

    @Override
    protected void writeNamespace(String prefix, String name) throws IOException {
        if (this.currentContext == null || this.currentContext instanceof BNode) {
            // empty if block
        }
        this.closeActiveContext();
        super.writeNamespace(prefix, name);
    }

    protected void closeActiveContext() throws IOException {
        if (this.inActiveContext) {
            this.writer.decreaseIndentation();
            this.writer.write("}");
            this.writer.writeEOL();
            this.inActiveContext = false;
            this.currentContext = null;
        }
    }

    private static final boolean contextsEquals(Resource context1, Resource context2) {
        if (context1 == null) {
            return context2 == null;
        }
        return context1.equals(context2);
    }
}

