/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;

public class RepositoryConfig {
    private String id;
    private String title;
    private RepositoryImplConfig implConfig;

    public RepositoryConfig() {
    }

    public RepositoryConfig(String id) {
        this();
        this.setID(id);
    }

    public RepositoryConfig(String id, RepositoryImplConfig implConfig) {
        this(id);
        this.setRepositoryImplConfig(implConfig);
    }

    public RepositoryConfig(String id, String title) {
        this(id);
        this.setTitle(title);
    }

    public RepositoryConfig(String id, String title, RepositoryImplConfig implConfig) {
        this(id, title);
        this.setRepositoryImplConfig(implConfig);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public RepositoryImplConfig getRepositoryImplConfig() {
        return this.implConfig;
    }

    public void setRepositoryImplConfig(RepositoryImplConfig implConfig) {
        this.implConfig = implConfig;
    }

    public void validate() throws RepositoryConfigException {
        if (this.id == null) {
            throw new RepositoryConfigException("Repository ID missing");
        }
        if (this.implConfig == null) {
            throw new RepositoryConfigException("Repository implementation for repository missing");
        }
        this.implConfig.validate();
    }

    @Deprecated
    public void export(Model model) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        this.export(model, vf.createBNode());
    }

    public void export(Model model, Resource repositoryNode) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        model.setNamespace(RDFS.NS);
        model.setNamespace(XSD.NS);
        model.setNamespace("rep", "http://www.openrdf.org/config/repository#");
        model.add(repositoryNode, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, new Resource[0]);
        if (this.id != null) {
            model.add(repositoryNode, RepositoryConfigSchema.REPOSITORYID, (Value)vf.createLiteral(this.id), new Resource[0]);
        }
        if (this.title != null) {
            model.add(repositoryNode, RDFS.LABEL, (Value)vf.createLiteral(this.title), new Resource[0]);
        }
        if (this.implConfig != null) {
            Resource implNode = this.implConfig.export(model);
            model.add(repositoryNode, RepositoryConfigSchema.REPOSITORYIMPL, (Value)implNode, new Resource[0]);
        }
    }

    public void parse(Model model, Resource repositoryNode) throws RepositoryConfigException {
        try {
            Models.objectLiteral(model.getStatements(repositoryNode, RepositoryConfigSchema.REPOSITORYID, null, new Resource[0])).ifPresent(lit -> this.setID(lit.getLabel()));
            Models.objectLiteral(model.getStatements(repositoryNode, RDFS.LABEL, null, new Resource[0])).ifPresent(lit -> this.setTitle(lit.getLabel()));
            Models.objectResource(model.getStatements(repositoryNode, RepositoryConfigSchema.REPOSITORYIMPL, null, new Resource[0])).ifPresent(res -> this.setRepositoryImplConfig(AbstractRepositoryImplConfig.create(model, res)));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }

    public static RepositoryConfig create(Model model, Resource repositoryNode) throws RepositoryConfigException {
        RepositoryConfig config = new RepositoryConfig();
        config.parse(model, repositoryNode);
        return config;
    }
}

