/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class Replace
implements Function {
    @Override
    public String getURI() {
        return FN.REPLACE.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length < 3 || args.length > 4) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for REPLACE: " + args.length);
        }
        try {
            Literal arg = (Literal)args[0];
            Literal pattern = (Literal)args[1];
            Literal replacement = (Literal)args[2];
            Literal flags = null;
            if (args.length == 4) {
                flags = (Literal)args[3];
            }
            if (!QueryEvaluationUtil.isStringLiteral(arg)) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + arg);
            }
            if (!QueryEvaluationUtil.isSimpleLiteral(pattern)) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + pattern);
            }
            if (!QueryEvaluationUtil.isSimpleLiteral(replacement)) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + replacement);
            }
            String flagString = null;
            if (flags != null) {
                if (!QueryEvaluationUtil.isSimpleLiteral(flags)) {
                    throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + flags);
                }
                flagString = flags.getLabel();
            }
            String argString = arg.getLabel();
            String patternString = pattern.getLabel();
            String replacementString = replacement.getLabel();
            int f = 0;
            if (flagString != null) {
                block10: for (char c : flagString.toCharArray()) {
                    switch (c) {
                        case 's': {
                            f |= 0x20;
                            continue block10;
                        }
                        case 'm': {
                            f |= 8;
                            continue block10;
                        }
                        case 'i': {
                            f |= 2;
                            continue block10;
                        }
                        case 'x': {
                            f |= 4;
                            continue block10;
                        }
                        case 'd': {
                            f |= 1;
                            continue block10;
                        }
                        case 'u': {
                            f |= 0x40;
                            continue block10;
                        }
                        default: {
                            throw new ValueExprEvaluationException(flagString);
                        }
                    }
                }
            }
            Pattern p = Pattern.compile(patternString, f);
            String result = p.matcher(argString).replaceAll(replacementString);
            Optional<String> lang = arg.getLanguage();
            IRI dt = arg.getDatatype();
            if (lang.isPresent()) {
                return valueFactory.createLiteral(result, lang.get());
            }
            if (dt != null) {
                return valueFactory.createLiteral(result, dt);
            }
            return valueFactory.createLiteral(result);
        }
        catch (ClassCastException e) {
            throw new ValueExprEvaluationException("literal operands expected", e);
        }
    }
}

