/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public abstract class QueryResultView
implements View {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String QUERY_RESULT_KEY = "queryResult";
    public static final String FACTORY_KEY = "factory";
    public static final String FILENAME_HINT_KEY = "filenameHint";
    public static final String CONNECTION_KEY = "connection";
    public static final String HEADERS_ONLY = "headersOnly";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.renderInternal(model, request, response);
        }
        finally {
            RepositoryConnection conn = (RepositoryConnection)model.get(CONNECTION_KEY);
            if (conn != null) {
                conn.close();
            }
        }
    }

    protected abstract void renderInternal(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    protected void setContentType(HttpServletResponse response, FileFormat fileFormat) throws IOException {
        String mimeType = fileFormat.getDefaultMIMEType();
        if (fileFormat.hasCharset()) {
            Charset charset = fileFormat.getCharset();
            mimeType = mimeType + "; charset=" + charset.name();
        }
        response.setContentType(mimeType);
    }

    protected void setContentDisposition(Map model, HttpServletResponse response, FileFormat fileFormat) throws IOException {
        String filename = (String)model.get(FILENAME_HINT_KEY);
        if (filename == null || filename.length() == 0) {
            filename = "result";
        }
        if (fileFormat.getDefaultFileExtension() != null) {
            filename = filename + "." + fileFormat.getDefaultFileExtension();
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + filename);
    }

    protected void logEndOfRequest(HttpServletRequest request) {
        if (this.logger.isInfoEnabled()) {
            String queryStr = request.getParameter("query");
            int qryCode = String.valueOf(queryStr).hashCode();
            this.logger.info("Request for query {} is finished", (Object)qryCode);
        }
    }
}

